/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportXmlMisuraOrariaService {
    private final String id;
    private final MisureDao misureDao;
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private final Map<String, String> misureType;

    public ExportXmlMisuraOrariaService(String id, MisureDao misureDao, PrebillingConfiguration configuration, Map<String, String> misureType, TalkManager talkManager) {
        this.id = id;
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.misureType = misureType;
        this.talkManager = talkManager;
    }

    public String export() throws DataNotFoundException, IOException {
        String xml;
        Pdo pdo = this.misureDao.getPdo(this.id, this.talkManager);
        String codiceFlusso = pdo.getFirstCodiceFlusso();
        Delibera delibera = pdo.getDelibera();
        TipoFlusso tipo = TipoFlusso.valueOf(codiceFlusso);
        try (StringWriter xmlWriter = new StringWriter();){
            try (PrintWriter writer = new PrintWriter(xmlWriter);){
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                String flusso = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" CodFlusso=\":flusso:\"".replaceAll(":flusso:", tipo.name());
                String context = this.getClass().getSimpleName();
                writer.println("<Flusso" + delibera.getTipo(tipo) + " " + flusso + ">");
                ExportXmlHelper.printIdentificativiFlusso(pdo, writer);
                tipo.printDatiPod(context, pdo, this.configuration, this.misureDao, this.misureType, writer, this.talkManager);
                writer.print("</Flusso" + tipo.getTipoD65() + ">");
            }
            xml = xmlWriter.toString();
        }
        return xml;
    }
}

