/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;

public class ExportXmlMisuraNonOrariaService {
    private final String id;
    private final MisureDao misureDao;
    private final PrebillingConfiguration configuration;
    private final Map<String, String> misureType;

    public ExportXmlMisuraNonOrariaService(String id, MisureDao misureDao, PrebillingConfiguration configuration, Map<String, String> misureType) {
        this.id = id;
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.misureType = misureType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String export() throws DataNotFoundException, IOException {
        Mno mno = this.misureDao.getMno(this.id);
        String codiceFlusso = mno.getCodiceFlusso();
        TipoFlusso tipo = TipoFlusso.valueOf(codiceFlusso);
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            String xml;
            StringWriter xmlWriter = new StringWriter();
            try {
                try (PrintWriter writer = new PrintWriter(xmlWriter);){
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    String flusso = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" CodFlusso=\":flusso:\"".replaceAll(":flusso:", tipo.name());
                    writer.println("<Flusso" + tipo.getTipoD65() + " " + flusso + ">");
                    ExportXmlHelper.printIdentificativiFlusso(mno, writer);
                    String context = this.getClass().getSimpleName();
                    tipo.printDatiPod(context, mno, this.configuration, this.misureDao, this.misureType, writer);
                    writer.print("</Flusso" + tipo.getTipoD65() + ">");
                    xml = xmlWriter.toString();
                }
                if (xmlWriter == null) return xml;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (xmlWriter == null) throw throwable;
                xmlWriter.close();
                throw throwable;
            }
            xmlWriter.close();
            return xml;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

