/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.DatiFlusso;
import biz.elabor.prebilling.model.misure.DatiFlussoMisura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import biz.elabor.prebilling.services.xml.export.AttivaExtractor;
import biz.elabor.prebilling.services.xml.export.DoubleExtractor;
import biz.elabor.prebilling.services.xml.export.ReattivaCapacitivaExtractor;
import biz.elabor.prebilling.services.xml.export.ReattivaExtractor;
import biz.elabor.prebilling.services.xml.export.ReattivaInduttivaExtractor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.structures.classifier.RecordMap;
import org.homelinux.elabor.tools.StringUtils;

public class ExportXmlHelper {
    public static final String FLUSSO = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" CodFlusso=\":flusso:\"";
    public static final DoubleExtractor ATTIVA_EXTRACTOR = new AttivaExtractor();
    public static final DoubleExtractor REATTIVA_EXTRACTOR = new ReattivaExtractor();
    public static final DoubleExtractor REATTIVA_CAPACITIVA_EXTRACTOR = new ReattivaCapacitivaExtractor();
    public static final DoubleExtractor REATTIVA_INDUTTIVA_EXTRACTOR = new ReattivaInduttivaExtractor();
    private static final Set<String> BANNED_2G = ExportXmlHelper.build2GBanned();
    public static final Set<String> BANNED_ENERGIA_CAPACITIVA_INDUTTIVA = ExportXmlHelper.buildBannedCapacitivaInduttiva();
    public static final Set<String> BANNED_ENERGIA_INDUTTIVA_ATTIVA_REATTIVA = ExportXmlHelper.buildBannedInduttivaAttivaReattiva();
    public static final Set<String> BANNED_ENERGIA_CAPACITIVA_ATTIVA_REATTIVA = ExportXmlHelper.buildBannedCapacitivaAttivaReattiva();
    public static final Set<String> BANNED_ENERGIA_FASCE_CAPACITIVA_INDUTTIVA = ExportXmlHelper.buildBannedFasceCapacitivaInduttiva();
    public static final Set<String> BANNED_ENERGIA_FASCE_INDUTTIVA_ATTIVA_REATTIVA = ExportXmlHelper.buildBannedFasceInduttivaAttivaReattiva();
    public static final Set<String> BANNED_ENERGIA_FASCE_CAPACITIVA_ATTIVA_REATTIVA = ExportXmlHelper.buildBannedFasceCapacitivaAttivaReattiva();
    private static final Map<String, DoubleExtractor> ENERGY_TYPES = ExportXmlHelper.buildEnergyTypes();
    public static final Set<String> TO_PRINT_ATTIVA_REATTIVA = ExportXmlHelper.buildAttivaReattiva();
    public static final Set<String> TO_PRINT_REATTIVA_CAPACITIVA = ExportXmlHelper.buildReattivaCapcitiva();
    public static final Set<String> TO_PRINT_REATTIVA_INDUTTIVA = ExportXmlHelper.buildReattivaInduttiva();
    private static final Map<String, String> SWITCH_TRANS = new HashMap<String, String>();
    private static final Set<String> BANNED_SNF;
    private static final Set<String> BANNED_SOF;

    static {
        SWITCH_TRANS.put("PotContrImp", "PotImp");
        BANNED_SNF = new HashSet<String>();
        BANNED_SNF.add("tipomisuratore");
        BANNED_SNF.add("datamessaregime");
        BANNED_SNF.add("residenza");
        BANNED_SNF.add("disalimentabilita");
        BANNED_SNF.add("configurazionemisuratore");
        BANNED_SNF.add("datainstmisatt");
        BANNED_SNF.add("datainstmisrea");
        BANNED_SNF.add("datainstmispot");
        BANNED_SOF = new HashSet<String>();
        BANNED_SOF.add("configurazionemisuratore");
        BANNED_SOF.add("disalimentabilita");
        BANNED_SOF.add("residenza");
        BANNED_SOF.add("datamessaregime");
        BANNED_SOF.add("tipomisuratore");
    }

    private static Set<String> buildBannedCapacitivaInduttiva() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("Erc");
        banned.add("Eri");
        return banned;
    }

    private static Set<String> buildBannedFasceCapacitivaInduttiva() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("ercf1");
        banned.add("ercf2");
        banned.add("ercf3");
        banned.add("ercf4");
        banned.add("ercf5");
        banned.add("ercf6");
        banned.add("erif1");
        banned.add("erif2");
        banned.add("erif3");
        banned.add("erif4");
        banned.add("erif5");
        banned.add("erif6");
        return banned;
    }

    private static Set<String> buildBannedFasceCapacitivaAttivaReattiva() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("ercf1");
        banned.add("ercf2");
        banned.add("ercf3");
        banned.add("ercf4");
        banned.add("ercf5");
        banned.add("ercf6");
        banned.add("eaf1");
        banned.add("eaf2");
        banned.add("eaf3");
        banned.add("eaf4");
        banned.add("eaf5");
        banned.add("eaf6");
        banned.add("erf1");
        banned.add("erf2");
        banned.add("erf3");
        banned.add("erf4");
        banned.add("erf5");
        banned.add("erf6");
        banned.add("potf1");
        banned.add("potf2");
        banned.add("potf3");
        banned.add("potf4");
        banned.add("potf5");
        banned.add("potf6");
        return banned;
    }

    private static Set<String> buildAttivaReattiva() {
        LinkedHashSet<String> toPrint = new LinkedHashSet<String>();
        toPrint.add("EaF1");
        toPrint.add("EaF2");
        toPrint.add("EaF3");
        toPrint.add("EaF4");
        toPrint.add("EaF5");
        toPrint.add("EaF6");
        toPrint.add("ErF1");
        toPrint.add("ErF2");
        toPrint.add("ErF3");
        toPrint.add("ErF4");
        toPrint.add("ErF5");
        toPrint.add("ErF6");
        toPrint.add("PotF1");
        toPrint.add("PotF2");
        toPrint.add("PotF3");
        toPrint.add("PotF4");
        toPrint.add("PotF5");
        toPrint.add("PotF6");
        toPrint.add("Erm");
        return toPrint;
    }

    private static Set<String> buildReattivaCapcitiva() {
        LinkedHashSet<String> toPrint = new LinkedHashSet<String>();
        toPrint.add("ErcF1");
        toPrint.add("ErcF2");
        toPrint.add("ErcF3");
        toPrint.add("ErcF4");
        toPrint.add("ErcF5");
        toPrint.add("ErcF6");
        toPrint.add("Ercm");
        return toPrint;
    }

    private static Set<String> buildReattivaInduttiva() {
        LinkedHashSet<String> toPrint = new LinkedHashSet<String>();
        toPrint.add("EriF1");
        toPrint.add("EriF2");
        toPrint.add("EriF3");
        toPrint.add("EriF4");
        toPrint.add("EriF5");
        toPrint.add("EriF6");
        toPrint.add("Erim");
        return toPrint;
    }

    private static Set<String> buildBannedFasceInduttivaAttivaReattiva() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("erif1");
        banned.add("erif2");
        banned.add("erif3");
        banned.add("erif4");
        banned.add("erif5");
        banned.add("erif6");
        banned.add("eaf1");
        banned.add("eaf2");
        banned.add("eaf3");
        banned.add("eaf4");
        banned.add("eaf5");
        banned.add("eaf6");
        banned.add("erf1");
        banned.add("erf2");
        banned.add("erf3");
        banned.add("erf4");
        banned.add("erf5");
        banned.add("erf6");
        banned.add("potf1");
        banned.add("potf2");
        banned.add("potf3");
        banned.add("potf4");
        banned.add("potf5");
        banned.add("potf6");
        return banned;
    }

    private static Map<String, DoubleExtractor> buildEnergyTypes() {
        LinkedHashMap<String, DoubleExtractor> map = new LinkedHashMap<String, DoubleExtractor>();
        map.put("Ea", ATTIVA_EXTRACTOR);
        map.put("Er", REATTIVA_EXTRACTOR);
        map.put("Erc", REATTIVA_CAPACITIVA_EXTRACTOR);
        map.put("Eri", REATTIVA_INDUTTIVA_EXTRACTOR);
        return map;
    }

    private static Set<String> buildBannedInduttivaAttivaReattiva() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("Eri");
        banned.add("Ea");
        banned.add("Er");
        return banned;
    }

    private static Set<String> buildBannedCapacitivaAttivaReattiva() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("Erc");
        banned.add("Ea");
        banned.add("Er");
        return banned;
    }

    private static Set<String> build2GBanned() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("matratt");
        banned.add("matrrea");
        banned.add("matrpot");
        banned.add("datainstmisatt");
        banned.add("datainstmisrea");
        banned.add("datainstmispot");
        banned.add("cifrepot");
        return banned;
    }

    public static void printDatiPod(String context, Mno mno, Map<String, Double> lastMap, Set<String> banned, ExtraPrinter<Mno> extraPrinter, PrebillingConfiguration configuration, PrintWriter writer, DecimalFormat itEnergyFormat, DateFormat longDateFormat, DateFormat dateFormat) {
        String codicePod = mno.getCodicePod();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        Date dataMisura = mno.getDataMisura();
        Map<String, Map<String, String>> datiPod = mno.getDatiPod();
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        String codPratAtt = mno.getCodPratAtt();
        if (codPratAtt != null && !codPratAtt.isEmpty()) {
            writer.println("<CodPratAtt>" + codPratAtt + "</CodPratAtt>");
        }
        extraPrinter.print(mno, dataMisura, writer);
        double ka = mno.getKa().doubleValue();
        double kr = mno.getKr().doubleValue();
        double kp = mno.getKp().doubleValue();
        for (String nomeDati : datiPod.keySet()) {
            writer.println("<" + nomeDati + ">");
            Map<String, String> dettagli = datiPod.get(nomeDati);
            StrategyHelper.printValueMap(dettagli, lastMap, banned, false, itEnergyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
            writer.println("</" + nomeDati + ">");
        }
        writer.println("</DatiPod>");
    }

    public static void printDatiPod2G(String context, Mno mno, RilGiorno rilGiorno, PrebillingConfiguration configuration, PrintWriter writer, DateFormat giornoFormat, DecimalFormat itEnergyFormat, DateFormat longDateFormat, DateFormat dateFormat) {
        String codicePod = mno.getCodicePod();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        Date dataMisura = mno.getDataMisura();
        Map<String, Map<String, String>> datiPod = mno.getDatiPod();
        String codPratAtt = mno.getCodPratAtt();
        Date dataPrestazione = mno.getDataPrestazione();
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        String dataString = dateFormat.format(dataMisura);
        writer.println("<DataMisura>" + dataString + "</DataMisura>");
        writer.println("<CodPrat_SII>" + codPratAtt + "</CodPrat_SII>");
        if (dataPrestazione != null) {
            String dataPrestazioneString = dateFormat.format(dataPrestazione);
            writer.println("<DataPrest>" + dataPrestazioneString + "</DataPrest>");
        }
        double ka = mno.getKa().doubleValue();
        double kr = mno.getKr().doubleValue();
        double kp = mno.getKp().doubleValue();
        for (String nomeDati : datiPod.keySet()) {
            writer.println("<" + nomeDati + ">");
            Map<String, String> dettagli = datiPod.get(nomeDati);
            StrategyHelper.printValueMap(dettagli, null, BANNED_2G, false, itEnergyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
            if (nomeDati.equals("Misura") && rilGiorno != null) {
                ExportXmlHelper.printGiorno(rilGiorno, writer, giornoFormat, itEnergyFormat, new HashSet<String>());
            }
            writer.println("</" + nomeDati + ">");
        }
        writer.println("</DatiPod>");
    }

    public static void printGiorno(RilGiorno rilGiorno, PrintWriter writer, DateFormat giornoFormat, DecimalFormat itEnergyFormat, Set<String> banned) {
        for (String energy : ENERGY_TYPES.keySet()) {
            if (banned.contains(energy)) continue;
            ExportXmlHelper.printGiorno(energy, rilGiorno, ENERGY_TYPES.get(energy), writer, giornoFormat, itEnergyFormat);
        }
    }

    public static void printDatiPod(String context, Pdo pdo, ExtraPrinter<Pdo> extraPrinter, PrebillingConfiguration configuration, PrintWriter writer, DateFormat giornoFormat, DecimalFormat meseFormat, DecimalFormat itEnergyFormat, DateFormat longDateFormat, DateFormat dateFormat) {
        RilMese rilMese = pdo.getRilMese();
        String codicePod = rilMese.getCodicePod();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        Map<String, Map<String, String>> datiPod = pdo.getDatiPod();
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        String codPratAtt = pdo.getCodPratAtt();
        if (codPratAtt != null && !codPratAtt.isEmpty()) {
            writer.println("<CodPratAtt>" + codPratAtt + "</CodPratAtt>");
        }
        int meseIndice = mese.getIndex();
        String meseTxt = meseFormat.format(meseIndice);
        writer.println("<MeseAnno>" + meseTxt + "/" + anno + "</MeseAnno>");
        extraPrinter.print(pdo, null, writer);
        double ka = pdo.getKa();
        double kr = pdo.getKr();
        double kp = pdo.getKp();
        for (String nomeDati : datiPod.keySet()) {
            writer.println("<" + nomeDati + ">");
            Map<String, String> mappaDettagli = datiPod.get(nomeDati);
            HashSet<String> banned = new HashSet<String>();
            StrategyHelper.printValueMap(mappaDettagli, null, banned, false, itEnergyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
            if (nomeDati.equals("Curva") || nomeDati.equals("Misura")) {
                ExportXmlHelper.printCurva(pdo, writer, giornoFormat, itEnergyFormat);
            }
            writer.println("</" + nomeDati + ">");
        }
        writer.println("</DatiPod>");
    }

    public static void printDatiPod479(String context, Pdo pdo, ExtraPrinter<Pdo> extraPrinter, PrebillingConfiguration configuration, PrintWriter writer, DateFormat giornoFormat, DecimalFormat meseFormat, DecimalFormat itEnergyFormat, DateFormat longDateFormat, DateFormat dateFormat) {
        RilMese rilMese = pdo.getRilMese();
        String codicePod = rilMese.getCodicePod();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        Map<String, Map<String, String>> datiPod = pdo.getDatiPod();
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        String codPratAtt = pdo.getCodPratAtt();
        if (codPratAtt != null && !codPratAtt.isEmpty()) {
            writer.println("<CodPratAtt>" + codPratAtt + "</CodPratAtt>");
        }
        int meseIndice = mese.getIndex();
        String meseTxt = meseFormat.format(meseIndice);
        writer.println("<MeseAnno>" + meseTxt + "/" + anno + "</MeseAnno>");
        extraPrinter.print(pdo, null, writer);
        double ka = pdo.getKa();
        double kr = pdo.getKr();
        double kp = pdo.getKp();
        for (String nomeDati : datiPod.keySet()) {
            writer.println("<" + nomeDati + ">");
            Map<String, String> mappaDettagli = datiPod.get(nomeDati);
            HashSet<String> banned = new HashSet<String>();
            StrategyHelper.printValueMap(mappaDettagli, null, banned, false, itEnergyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
            if (nomeDati.equals("Curva") || nomeDati.equals("Misura")) {
                ExportXmlHelper.printCurva(pdo, writer, giornoFormat, itEnergyFormat);
            }
            writer.println("</" + nomeDati + ">");
        }
        writer.println("</DatiPod>");
    }

    public static void printDatiPod(String context, Sof sof, PrebillingConfiguration configuration, PrintWriter writer, DecimalFormat itEnergyFormat, DateFormat longDateFormat, DateFormat dateFormat, double ka, double kr, double kp) {
        String codicePod = sof.getCodicePod();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        writer.println("<CodPratAtt>" + sof.getCodPratAtt() + "</CodPratAtt>");
        Date dataInizio = sof.getDataInizio();
        String dataString = dateFormat.format(dataInizio);
        writer.println("<DataInizio>" + dataString + "</DataInizio>");
        Map<String, String> datiPdp = sof.getDatiPdp();
        writer.println("<DatiPdp>");
        StrategyHelper.printValueMap(datiPdp, null, BANNED_SOF, SWITCH_TRANS, false, itEnergyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
        writer.println("</DatiPdp>");
        writer.println("</DatiPod>");
    }

    public static void printDatiPod(String context, Snf snf, PrebillingConfiguration configuration, PrintWriter writer, DecimalFormat itEnergyFormat, DateFormat longDateFormat, DateFormat dateFormat) {
        String codicePod = snf.getCodicePod();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        writer.println("<CodPratAtt>" + snf.getCodPratAtt() + "</CodPratAtt>");
        Date dataInizio = snf.getDataInizio();
        String dataString = dateFormat.format(dataInizio);
        writer.println("<DataInizio>" + dataString + "</DataInizio>");
        Map<String, String> datiPdp = snf.getDatiPdp();
        writer.println("<DatiPdp>");
        double ka = snf.getKa().doubleValue();
        double kr = snf.getKr().doubleValue();
        double kp = snf.getKp().doubleValue();
        StrategyHelper.printValueMap(datiPdp, null, BANNED_SNF, SWITCH_TRANS, false, itEnergyFormat, configuration, writer, longDateFormat, dateFormat, ka, kr, kp);
        writer.println("</DatiPdp>");
        writer.println("</DatiPod>");
    }

    public static void printCurva(Pdo pdo, PrintWriter writer, DateFormat giornoFormat, DecimalFormat itEnergyFormat) {
        RilMese rilMese = pdo.getRilMese();
        ExportXmlHelper.printMese(rilMese, writer, giornoFormat, itEnergyFormat, new HashSet<String>());
    }

    public static void printMese(List<? extends RilGiorno> rilMese, PrintWriter writer, DateFormat giornoFormat, DecimalFormat itEnergyFormat, Set<String> banned) {
        for (String energy : ENERGY_TYPES.keySet()) {
            if (banned.contains(energy)) continue;
            ExportXmlHelper.printMese(energy, rilMese, ENERGY_TYPES.get(energy), writer, giornoFormat, itEnergyFormat);
        }
    }

    public static void printMese(String tag, List<? extends RilGiorno> rilMese, DoubleExtractor extractor, PrintWriter writer, DateFormat giornoFormat, DecimalFormat itEnergyFormat) {
        if (rilMese != null) {
            for (RilGiorno rilGiorno : rilMese) {
                ExportXmlHelper.printGiorno(tag, rilGiorno, extractor, writer, giornoFormat, itEnergyFormat);
            }
        }
    }

    public static void printGiorno(String tag, RilGiorno rilGiorno, DoubleExtractor extractor, PrintWriter writer, DateFormat giornoFormat, DecimalFormat itEnergyFormat) {
        if (rilGiorno != null && extractor.hasRilGiorno(rilGiorno)) {
            Date data = rilGiorno.getDate();
            String giorno = giornoFormat.format(data);
            boolean solarToLegal = CalendarTools.getHoursOfDay(data) == 23;
            boolean legalToSolar = CalendarTools.getHoursOfDay(data) == 25;
            writer.print("<" + tag);
            if (solarToLegal) {
                writer.print(" Dst=\"1\"");
            } else if (legalToSolar) {
                writer.print(" Dst=\"2\"");
            }
            for (RilQuarto rilQuarto : rilGiorno) {
                int index = rilQuarto.getIndex();
                if (solarToLegal && index > 7) {
                    index += 4;
                } else if (legalToSolar && index > 11) {
                    index -= 4;
                }
                Double energia = extractor.get(rilQuarto);
                if (energia == null) continue;
                writer.print(" E" + (index + 1) + "=\"" + itEnergyFormat.format(energia) + "\"");
                if (!legalToSolar || rilQuarto.getIndex() != 11) continue;
                writer.println(">" + giorno + "</" + tag + ">");
                writer.print("<" + tag + " Dst=\"3\"");
            }
            writer.println(">" + giorno + "</" + tag + ">");
        }
    }

    public static void printIdentificativiFlusso(DatiFlusso dati, PrintWriter writer) {
        writer.println("<IdentificativiFlusso>");
        writer.println("<PIvaUtente>" + dati.getPivaUtente() + "</PIvaUtente>");
        writer.println("<PIvaDistributore>" + dati.getPivaDistributore() + "</PIvaDistributore>");
        writer.println("<CodContrDisp>" + dati.getCodContrDisp() + "</CodContrDisp>");
        writer.println("</IdentificativiFlusso>");
    }

    public static RilGiorno buildRilGiorno(Date data, String codiceFlusso, String id, Mno2GE pno2geaPod, Mno2GE pno2gerPod, Mno2GE pno2gercPod, Mno2GE pno2geriPod) {
        RilGiorno rilGiorno;
        if (pno2geaPod != null && pno2gerPod != null) {
            Double[] attiva = pno2geaPod.getEnergiaOraria();
            Double[] reattiva = pno2gerPod.getEnergiaOraria();
            Double[] reattivaCapacitiva = pno2gercPod != null ? pno2gercPod.getEnergiaOraria() : null;
            Double[] reattivaInduttiva = pno2geriPod != null ? pno2geriPod.getEnergiaOraria() : null;
            rilGiorno = new RilGiorno(data, codiceFlusso, id, attiva, reattiva, reattivaCapacitiva, reattivaInduttiva, RilQuartoType.REALE);
        } else {
            rilGiorno = null;
        }
        return rilGiorno;
    }

    public static Map<String, Double> getLastMap(Pod pod) {
        HashMap<String, Double> lastMap = new HashMap<String, Double>();
        double[] lastAttiva = pod.getLastAttiva();
        double[] lastReattiva = pod.getLastReattiva();
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            lastMap.put("Ea" + fascia.name(), lastAttiva[fascia.ordinal()]);
            lastMap.put("Er" + fascia.name(), lastReattiva[fascia.ordinal()]);
            ++n3;
        }
        return lastMap;
    }

    public static void printTag(String tag, String value, PrintWriter writer) {
        if (value != null && !value.trim().isEmpty()) {
            writer.println("<" + tag + ">" + value + "</" + tag + ">");
        }
    }

    public static void printTag(String tag, Date date, PrintWriter writer, DateFormat dateFormat) {
        if (date != null) {
            String dateString = dateFormat.format(date);
            writer.println("<" + tag + ">" + dateString + "</" + tag + ">");
        }
    }

    public static void printTag(String tag, Number value, PrintWriter writer) {
        ExportXmlHelper.printTag(tag, value == null ? null : value.toString(), writer);
    }

    public static void printTag(String tag, Number value, DecimalFormat format, PrintWriter writer) {
        ExportXmlHelper.printTag(tag, value == null ? null : format.format(value.doubleValue()), writer);
    }

    public static void fillSegnanti(Map<String, String> datiMisura, Double[] segnantiERc, Double[] segnantiERi, DecimalFormat format) {
        ExportXmlHelper.fillSegnanti(datiMisura, "Erc", segnantiERc, format);
        ExportXmlHelper.fillSegnanti(datiMisura, "Eri", segnantiERi, format);
    }

    private static void fillSegnanti(Map<String, String> datiMisura, String tipo, Double[] segnanti, DecimalFormat format) {
        int index = 1;
        Double[] doubleArray = segnanti;
        int n2 = segnanti.length;
        int n3 = 0;
        while (n3 < n2) {
            Double segnante = doubleArray[n3];
            if (segnante != null) {
                String value = format.format(segnante);
                datiMisura.put(String.valueOf(tipo) + "F" + index, value);
            }
            ++index;
            ++n3;
        }
    }

    public static void fillSegnanti(Map<String, String> datiMisura, Mno2GE erc, Mno2GE eri, DecimalFormat format) {
        Double[] segnantiERc = erc == null ? new Double[6] : erc.getEnergiaFascia();
        Double[] segnantiERi = eri == null ? new Double[6] : eri.getEnergiaFascia();
        ExportXmlHelper.fillSegnanti(datiMisura, segnantiERc, segnantiERi, format);
    }

    public static void fillDatiMisura(Mno item, RecordMap<String, Mno2GE> pdo2gRErc, RecordMap<String, Mno2GE> pdo2gREri, RilGiorno rilGiorno, DecimalFormat format) {
        if (rilGiorno != null) {
            String codicePod = item.getCodicePod();
            Date data = rilGiorno.getDate();
            String key = Mno2GE.getKey(codicePod, data);
            Mno2GE erc = pdo2gRErc.get(key);
            Mno2GE eri = pdo2gREri.get(key);
            Map<String, Map<String, String>> datiPod = item.getDatiPod();
            Map<String, String> datiMisure = datiPod.get("Misura");
            ExportXmlHelper.fillSegnanti(datiMisure, erc, eri, format);
        }
    }

    public static void printCausaOstativa(DatiFlussoMisura mno, PrintWriter writer) {
        String causaOstativa = mno.getCausaOstativa();
        if (!StringUtils.isEmpty(causaOstativa)) {
            ExportXmlHelper.printTag("CausaOstativa", causaOstativa, writer);
        }
    }
}

