/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.AbstractFlussoFDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportSofXmlStrategy
extends AbstractExportXmlStrategy<Sof> {
    private final ExportXmlHandler handler;

    public ExportSofXmlStrategy(Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(TipoFlusso.SOF, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<Delibera, Sof> sofs = this.handler.getSofs(status);
        return this.export(sofs, status);
    }

    @Override
    public void printItem(Sof item, ServiceStatus status, PrintWriter writer) {
        String className = this.getClass().getSimpleName();
        if (item.getDelibera().isDelibera65()) {
            double ka = item.getKa().doubleValue();
            double kr = item.getKr().doubleValue();
            double kp = item.getKp().doubleValue();
            ExportXmlHelper.printDatiPod(className, item, this.configuration, writer, this.itEnergyFormat, this.longDataFormat, this.dataFormat, ka, kr, kp);
        } else {
            AbstractFlussoFDatiPodPrinter<Sof> datiPodPrinter = new AbstractFlussoFDatiPodPrinter<Sof>();
            datiPodPrinter.print(className, item, writer);
        }
        SofResult result = new SofResult(item, ErroriElaborazione.OK, "");
        status.addSofEsportato(result);
    }
}

