/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.SmisDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import java.io.PrintWriter;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.ListMapKey;

public class ExportSmisXmlStrategy
extends AbstractExportXmlStrategy<Mno> {
    private final ExportXmlHandler handler;
    private Mno previous = null;

    public ExportSmisXmlStrategy(Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(TipoFlusso.SMIS, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMapKey<String, Mno> pnos = this.handler.getSmis(status);
        Iterable iterable = pnos.iterable();
        return this.export(Delibera.D479, iterable, status);
    }

    @Override
    public void printItem(Mno item, ServiceStatus status, PrintWriter writer) {
        if (this.previous == null) {
            this.previous = item;
        } else {
            String codPrev = this.previous.getCodicePod();
            String codActual = item.getCodicePod();
            MnoResult previousResult = new MnoResult(this.previous, ErroriElaborazione.OK, "");
            status.addSmisEsportato(previousResult);
            if (codPrev.equals(codActual)) {
                this.printSmis(this.previous, item, writer);
                MnoResult itemResult = new MnoResult(item, ErroriElaborazione.OK, "");
                status.addSmisEsportato(itemResult);
                this.previous = null;
            } else {
                this.printLastSmis(previousResult, status, writer);
                this.previous = item;
            }
        }
    }

    @Override
    public void finish(ServiceStatus status, PrintWriter writer) {
        if (this.previous != null) {
            MnoResult previousResult = new MnoResult(this.previous, ErroriElaborazione.OK, "");
            this.printLastSmis(previousResult, status, writer);
        }
    }

    private void printSmis(Mno smontaggio, Mno montaggio, PrintWriter writer) {
        String codicePod = montaggio.getCodicePod();
        String context = this.getClass().getSimpleName();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        SmisDatiPodPrinter datiPodPrinter = new SmisDatiPodPrinter(this.configuration);
        datiPodPrinter.print(smontaggio, montaggio, writer);
    }

    private void printLastSmis(MnoResult result, ServiceStatus status, PrintWriter writer) {
        if (this.previous.getRaccolta().equals("M")) {
            this.printSmis(null, this.previous, writer);
            status.addSmisEsportato(result);
        } else {
            Warning sentence = new Warning("export.xmld65", "smis.fuorisequenza");
            sentence.setCss("alert-danger");
            MisuraNonoraria record = (MisuraNonoraria)result.getRecord();
            String codicePod = record.getCodicePod();
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
        }
        this.previous = null;
    }
}

