/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.xml.export.TipoDato;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportSingleXmlStrategy
implements ServiceStrategy {
    private final String id;
    private final String tipoDatoStr;
    private final MisureDao misureDao;
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private String xml;

    public ExportSingleXmlStrategy(String id, String tipoDatoStr, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.id = id;
        this.tipoDatoStr = tipoDatoStr;
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        try {
            TipoDato tipoDato = TipoDato.valueOf(this.tipoDatoStr.toUpperCase());
            Map<String, String> misureType = status.getMisureType();
            this.xml = tipoDato.export(this.id, this.misureDao, this.configuration, misureType, this.talkManager);
        }
        catch (IllegalArgumentException exc) {
            Message sentence = new Message("xmldel65", "tipodato.notfound");
            sentence.addParam(this.tipoDatoStr);
            this.talkManager.addSentence(sentence);
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            Message sentence = new Message("xmldel65", message);
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
        }
        catch (IOException exc) {
            String message = exc.toString();
            Message sentence = new Message("xmldel65", message);
            this.talkManager.addSentence(sentence);
            Logger logger = status.getLogger();
            String userMessage = this.talkManager.getMessage(sentence);
            logger.log(Level.SEVERE, userMessage, exc);
        }
        return true;
    }

    public String getXml() {
        return this.xml;
    }
}

