/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.RFODatiPodPrinter;
import biz.elabor.prebilling.services.xml.d65.BasicExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.RettificaExtraPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportRfoXmlStrategy
extends AbstractExportXmlStrategy<Pdo> {
    private ExportXmlHandler handler;
    private static final ExtraPrinter<Pdo> EXTRA_PRINTER = new RettificaExtraPrinter<Pdo>(new BasicExtraPrinter());

    public ExportRfoXmlStrategy(TipoFlusso flusso, Funzionalita funzionalita, String reseller, ExportXmlHandler handler, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(flusso, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<Delibera, Pdo> rfos = this.handler.getRfos(status);
        return this.export(rfos, status);
    }

    @Override
    public void printItem(Pdo item, ServiceStatus status, PrintWriter writer) {
        Class<?> strategyClass = this.getClass();
        String className = strategyClass.getSimpleName();
        if (item.getDelibera().isDelibera65()) {
            ExportXmlHelper.printDatiPod(className, item, EXTRA_PRINTER, this.configuration, writer, this.giornoFormat, this.meseFormat, this.itEnergyFormat, this.longDataFormat, this.dataFormat);
        } else {
            Map<String, String> misureType = status.getMisureType();
            RFODatiPodPrinter datiPodPrinter = new RFODatiPodPrinter(this.configuration, misureType);
            datiPodPrinter.print(className, item, writer);
        }
        PdoResult result = new PdoResult(item, ErroriElaborazione.OK, "");
        status.addRfoEsportato(result);
    }
}

