/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.DatiFlusso;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import biz.elabor.prebilling.services.xml.extractor.AziendaExtractor;
import biz.elabor.prebilling.services.xml.extractor.DistributoreExtractor;
import biz.elabor.prebilling.services.xml.extractor.PeriodoExtractor;
import biz.elabor.prebilling.services.xml.extractor.RegimeExtractor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.file.SizePrintWriter;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.builders.ArrayListBuilder;
import org.homelinux.elabor.structures.listmap.ListMap;

public abstract class AbstractExportXmlStrategy<T extends DatiFlusso>
implements ServiceStrategy {
    private final TipoFlusso tipo;
    private final Funzionalita funzionalita;
    protected final PrebillingConfiguration configuration;
    private final String reseller;
    protected final TalkManager talkManager;
    private final String folderSuffix;
    protected final DateFormat timestampFormat;
    protected final DecimalFormat itEnergyFormat;
    protected final DateFormat dataFormat;
    protected final DateFormat longDataFormat;
    protected final DateFormat giornoFormat;
    protected final DecimalFormat meseFormat;
    private Map<String, Integer> mappaProgressivi;

    public abstract void printItem(T var1, ServiceStatus var2, PrintWriter var3);

    public AbstractExportXmlStrategy(TipoFlusso tipo, Funzionalita funzionalita, PrebillingConfiguration configuration, String reseller, TalkManager talkManager, String folderSuffix) {
        this.tipo = tipo;
        this.funzionalita = funzionalita;
        this.configuration = configuration;
        this.reseller = reseller;
        this.talkManager = talkManager;
        this.folderSuffix = folderSuffix;
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
        this.itEnergyFormat = StrategyHelper.getItEnergyFormat();
        this.dataFormat = StrategyHelper.getDataFormat();
        this.longDataFormat = StrategyHelper.getFullDateFormat();
        this.meseFormat = StrategyHelper.getMeseNumFormat();
        this.giornoFormat = StrategyHelper.getGiornoFormat();
        this.mappaProgressivi = new HashMap<String, Integer>();
    }

    public boolean export(ListMap<Delibera, T> map, ServiceStatus status) {
        boolean ok = true;
        for (Map.Entry entry : map.entrySet()) {
            Delibera delibera = (Delibera)((Object)entry.getKey());
            List value = (List)entry.getValue();
            ok &= this.export(delibera, value, status);
        }
        return ok;
    }

    public boolean export(Delibera delibera, Iterable<T> items, ServiceStatus status) {
        boolean ok = true;
        AziendaExtractor extractor = new AziendaExtractor();
        HashMap map = new HashMap();
        ArrayListBuilder builder = new ArrayListBuilder();
        StructuresHelper.buildCollectionsMap(map, items, extractor, builder);
        for (Map.Entry entry : map.entrySet()) {
            String azienda = (String)entry.getKey();
            if (!StrategyHelper.matchReseller(azienda, this.reseller)) continue;
            String className = this.getClass().getSimpleName();
            PrebillingContext.setContext(className, "azienda: " + azienda);
            List aziendaItems = (List)entry.getValue();
            ok &= this.exportAzienda(delibera, azienda, aziendaItems, status);
        }
        return ok;
    }

    private boolean exportAzienda(Delibera delibera, String azienda, List<T> items, ServiceStatus status) {
        HashMap map = new HashMap();
        DistributoreExtractor extractor = new DistributoreExtractor();
        ArrayListBuilder builder = new ArrayListBuilder();
        StructuresHelper.buildCollectionsMap(map, items, extractor, builder);
        String idEsecuzione = status.getIdEsecuzione();
        File folder = ConfigurationHelper.getResellerTmpXmlFolder(this.configuration, idEsecuzione, azienda, this.funzionalita, this.folderSuffix);
        boolean ok = true;
        for (Map.Entry entry : map.entrySet()) {
            String pivaDdistributore = (String)entry.getKey();
            List distributoreItems = (List)entry.getValue();
            ok &= this.exportDistributore(folder, delibera, pivaDdistributore, distributoreItems, status);
        }
        return ok;
    }

    private boolean exportDistributore(File folder, Delibera delibera, String pivaDistributore, List<T> items, ServiceStatus status) {
        PeriodoExtractor extractor = new PeriodoExtractor();
        HashMap map = new HashMap();
        ArrayListBuilder builder = new ArrayListBuilder();
        StructuresHelper.buildCollectionsMap(map, items, extractor, builder);
        boolean ok = true;
        for (Map.Entry entry : map.entrySet()) {
            WorkingPeriod period = (WorkingPeriod)entry.getKey();
            List periodItems = (List)entry.getValue();
            ok &= this.exportPeriodo(folder, delibera, pivaDistributore, period, periodItems, status);
        }
        return ok;
    }

    private boolean exportPeriodo(File folder, Delibera delibera, String pivaDistributore, WorkingPeriod period, List<T> items, ServiceStatus status) {
        HashMap map = new HashMap();
        RegimeExtractor extractor = new RegimeExtractor();
        ArrayListBuilder builder = new ArrayListBuilder();
        StructuresHelper.buildCollectionsMap(map, items, extractor, builder);
        boolean ok = true;
        for (Map.Entry entry : map.entrySet()) {
            String regime = (String)entry.getKey();
            List regimeItems = (List)entry.getValue();
            ok &= this.exportRegime(folder, delibera, pivaDistributore, period, regime, regimeItems, status);
        }
        return ok;
    }

    private boolean exportRegime(File folder, Delibera delibera, String pivaDistributore, WorkingPeriod period, String regime, List<T> items, ServiceStatus status) {
        String timestamp = this.timestampFormat.format(new Date());
        DatiFlusso item = (DatiFlusso)items.get(0);
        String pivaDispatcher = item.getPivaUtente();
        String codContrDisp = item.getCodContrDisp();
        boolean ok = true;
        String key = String.valueOf(delibera.name()) + "|" + pivaDistributore + "|" + period.toString() + "|" + regime;
        Integer value = this.mappaProgressivi.get(key);
        int progressivo = value == null ? 0 : value;
        Iterator<T> iterator = items.iterator();
        while (iterator.hasNext() && ok) {
            String fileName = this.tipo.getFileName(delibera, pivaDistributore, pivaDispatcher, period, timestamp, regime, codContrDisp, ++progressivo);
            File subfolder = new File(folder, delibera.name());
            subfolder.mkdirs();
            File file = new File(subfolder, fileName);
            try {
                Throwable throwable = null;
                Object var21_23 = null;
                try (SizePrintWriter sizeWriter = new SizePrintWriter(file);){
                    PrintWriter writer = sizeWriter.getPrintWriter();
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    String flusso = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" CodFlusso=\":flusso:\"".replaceAll(":flusso:", this.tipo.name());
                    String tipoFlusso = delibera.getTipo(this.tipo);
                    String codiceFlusso = this.tipo.name();
                    writer.println("<Flusso" + tipoFlusso + " " + flusso + ">");
                    ExportXmlHelper.printIdentificativiFlusso(item, writer);
                    this.exportItems(codiceFlusso, items, status, sizeWriter, iterator);
                    writer.print("</Flusso" + tipoFlusso + ">");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exc) {
                Warning sentence = new Warning("export.xmld65", "file.createFailed");
                sentence.setCss("alert-danger");
                sentence.addParam(file.getAbsolutePath());
                this.talkManager.addSentence(sentence);
                ok = false;
            }
        }
        this.mappaProgressivi.put(key, progressivo);
        return ok;
    }

    private List<T> exportItems(String codiceFlusso, List<T> items, ServiceStatus status, SizePrintWriter sizeWriter, Iterator<T> iterator) {
        PrintWriter writer = sizeWriter.getPrintWriter();
        do {
            DatiFlusso item = (DatiFlusso)iterator.next();
            this.printItem(item, status, writer);
            String azienda = item.getCdaziend();
            status.count(azienda, codiceFlusso, 1);
        } while (sizeWriter.size() < this.configuration.getXmlMaxSize() && iterator.hasNext());
        this.finish(status, writer);
        return items;
    }

    public void finish(ServiceStatus status, PrintWriter writer) {
    }
}

