/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.MNODatiPodPrinter;
import biz.elabor.prebilling.services.xml.d65.BasicExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.MnoExtraPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public abstract class AbstractExportMnoXmlStrategy
extends AbstractExportXmlStrategy<Mno> {
    private static final ExtraPrinter<Mno> EXTRA_PRINTER = new MnoExtraPrinter(new BasicExtraPrinter<Mno>());
    protected final ExportXmlHandler handler;

    protected abstract ListMap<Delibera, Mno> getItems(ServiceStatus var1);

    protected abstract void addResult(MnoResult var1, ServiceStatus var2);

    public AbstractExportMnoXmlStrategy(TipoFlusso tipoFlusso, Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(tipoFlusso, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<Delibera, Mno> items = this.getItems(status);
        return this.export(items, status);
    }

    @Override
    public void printItem(Mno item, ServiceStatus status, PrintWriter writer) {
        String className = this.getClass().getSimpleName();
        if (item.getDelibera().isDelibera65()) {
            HashSet<String> banned = new HashSet<String>();
            ExportXmlHelper.printDatiPod(className, item, null, banned, EXTRA_PRINTER, this.configuration, writer, this.itEnergyFormat, this.longDataFormat, this.dataFormat);
        } else {
            Map<String, String> misureType = status.getMisureType();
            MNODatiPodPrinter datiPodPrinter = new MNODatiPodPrinter(this.configuration, misureType);
            datiPodPrinter.print(className, item, writer);
        }
        MnoResult result = new MnoResult(item, ErroriElaborazione.OK, "");
        this.addResult(result, status);
    }
}

