/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.ds;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.services.xml.AbstractGetXmlStrategy;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.ds.GetDS2GPeriodoXmlGetter;
import biz.elabor.prebilling.services.xml.periodo.GetPnoEA;
import biz.elabor.prebilling.services.xml.periodo.GetPnoER;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import biz.elabor.prebilling.web.xml.filtri.FiltriXml;
import java.util.List;
import org.homelinux.elabor.structures.listmap.ListMap;

public class GetDS2GXmlStrategy
extends AbstractGetXmlStrategy
implements IsolableServiceStrategy {
    private final String azienda;

    public GetDS2GXmlStrategy(String azienda, FiltriXml filtri, MisureDao misureDao) {
        super(filtri, misureDao);
        this.azienda = azienda;
    }

    @Override
    public boolean executePartition(ServiceStatus status, Partition partition) {
        GetDS2GPeriodoXmlGetter periodo2GGetter = new GetDS2GPeriodoXmlGetter(partition);
        List<Mno> misure = this.getFlussiRaccolta(this.azienda, TipoFlusso.DS2G, periodo2GGetter);
        status.setDS2GXml(misure);
        this.set2GE(status, partition, this.azienda);
        return true;
    }

    private void set2GE(ServiceStatus status, Partition partition, String azienda) {
        GetPnoEA getterA = new GetPnoEA();
        List<Mno2GE> misureA = this.getFlussi(azienda, TipoFlusso.DS2G, partition, getterA);
        if (!misureA.isEmpty()) {
            GetPnoER getterR = new GetPnoER();
            List<Mno2GE> misureR = this.getFlussi(azienda, TipoFlusso.DS2G, partition, getterR);
            ListMap<String, Mno2GE> misureRMap = GetDS2GXmlStrategy.buildMisureMap(misureR);
            status.setMisure2gEA(misureA);
            status.setMisure2gER(GetDS2GXmlStrategy.getMisure(misureRMap, "T"));
            status.setMisure2gERc(GetDS2GXmlStrategy.getMisure(misureRMap, "C"));
            status.setMisure2gERi(GetDS2GXmlStrategy.getMisure(misureRMap, "I"));
        }
    }

    @Override
    public boolean execute(ServiceStatus status) {
        throw new RuntimeException("not allowed");
    }
}

