/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.ds;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.RTR2GRDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;

public class DSR2GDatiPodPrinter
extends RTR2GRDatiPodPrinter {
    public DSR2GDatiPodPrinter(RilGiorno rilGiorno, PrebillingConfiguration configuration, Map<String, String> misuraType) {
        super(rilGiorno, configuration, misuraType);
    }

    @Override
    protected void printMisuraMese(Mno item, String potMax, PrintWriter writer) {
        String idTipoMisura = item.getIdTipoMisura();
        writer.println("<Misura xsi:type=\"" + this.getTipoMisura(idTipoMisura) + "\">");
        ExportXmlHelper.printCausaOstativa(item, writer);
        Map<String, String> dettagli = item.getDatiPod().get("Misura");
        HashSet<String> banned = new HashSet<String>();
        banned.add("tipodato");
        banned.add("raccolta");
        banned.add("validato");
        banned.add("potmax");
        double ka = StrategyHelper.getK(item.getKa());
        double kr = StrategyHelper.getK(item.getKr());
        double kp = StrategyHelper.getK(item.getKp());
        StrategyHelper.printValueMap(dettagli, null, banned, false, this.itEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
        writer.println("</Misura>");
    }
}

