/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d65;

import biz.elabor.prebilling.model.misure.DatiFlussoMisura;
import biz.elabor.prebilling.model.misure.DefaultDatiFlusso;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class RettificaExtraPrinter<T extends DatiFlussoMisura>
implements ExtraPrinter<T> {
    private final ExtraPrinter<T> baseExtraPrinter;
    private final DateFormat dateFormat;

    public RettificaExtraPrinter(ExtraPrinter<T> baseExtraPrinter) {
        this.baseExtraPrinter = baseExtraPrinter;
        this.dateFormat = StrategyHelper.getDataFormat();
    }

    @Override
    public void print(T dati, Date dataMisura, PrintWriter writer) {
        this.baseExtraPrinter.print(dati, dataMisura, writer);
        if (!((DefaultDatiFlusso)dati).getDelibera().isDelibera65()) {
            writer.println("<TipoRettifica>" + ((DatiFlussoMisura)dati).getTipoRettifica() + "</TipoRettifica>");
            Date dataRilevazione = ((DatiFlussoMisura)dati).getDataRilevazione();
            if (dataRilevazione != null) {
                String dataString = this.dateFormat.format(dataRilevazione);
                writer.println("<DataRilevazione>" + dataString + "</DataRilevazione>");
            }
        }
        writer.println("<Motivazione>" + ((DatiFlussoMisura)dati).getMotivazione() + "</Motivazione>");
    }
}

