/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilData;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.AbstractOrariDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.tools.StringUtils;

public class RFODatiPodPrinter
extends AbstractOrariDatiPodPrinter {
    public RFODatiPodPrinter(PrebillingConfiguration configuration, Map<String, String> misuraType) {
        super(configuration, misuraType);
    }

    @Override
    public void print(String context, Pdo item, PrintWriter writer) {
        String codicePod = item.getCodicePod();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        ListMap<Date, RilData> rilMap = item.getRilMap();
        ArrayList entrySet = new ArrayList(rilMap.entrySet());
        Collections.reverse(entrySet);
        for (Map.Entry entry : entrySet) {
            Date dataRilevazione = (Date)entry.getKey();
            List rilDataList = (List)entry.getValue();
            writer.println("<DatiPod>");
            writer.println("<Pod>" + codicePod + "</Pod>");
            this.printDatiPod(item, dataRilevazione, rilDataList, writer);
            writer.println("</DatiPod>");
        }
    }

    public void printDatiPod(Pdo rfo, Date dataRilevazione, List<RilData> rilDataList, PrintWriter writer) {
        RilMese rilMese = rfo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        int meseIndice = mese.getIndex();
        String meseTxt = this.meseFormat.format(meseIndice);
        String meseAnno = String.valueOf(meseTxt) + "/" + anno;
        RilData rilData = rilDataList.get(0);
        ExportXmlHelper.printTag("MeseAnno", meseAnno, writer);
        ExportXmlHelper.printTag("TipoRettifica", rilData.getTipoRettifica(), writer);
        ExportXmlHelper.printTag("DataRilevazione", dataRilevazione, writer, this.dataFormat);
        String motivazione = rilData.getMotivazione();
        if (motivazione == null) {
            motivazione = rfo.getMotivazione();
        }
        ExportXmlHelper.printTag("Motivazione", motivazione, writer);
        this.printDatiPdp(rilData, writer);
        this.printMisura(rfo, rilDataList, writer);
    }

    public final void printMisura(Pdo item, List<RilData> rilDataList, PrintWriter writer) {
        String idTipoMisura = item.getIdTipoMisura();
        writer.println("<Misura xsi:type=\"" + this.getTipoMisura(idTipoMisura) + "\">");
        this.printDatiMisura(item, rilDataList, writer);
        writer.println("</Misura>");
    }

    protected void printDatiPdp(RilData rilData, PrintWriter writer) {
        String gruppoMisura;
        writer.println("<DatiPdp>");
        String trattamento = rilData.getTrattamento();
        ExportXmlHelper.printTag("Trattamento", trattamento, writer);
        ExportXmlHelper.printTag("Tensione", rilData.getTensione(), writer);
        String forfait = rilData.getForfait();
        if (StringUtils.isEmpty(forfait)) {
            forfait = "NO";
        }
        if (StringUtils.isEmpty(gruppoMisura = rilData.getGruppoMisura())) {
            gruppoMisura = "SI";
        }
        ExportXmlHelper.printTag("Forfait", forfait, writer);
        ExportXmlHelper.printTag("GruppoMis", gruppoMisura, writer);
        String kaString = rilData.getKaString();
        String krString = rilData.getKrString();
        String kpString = rilData.getKpString();
        double ka = rilData.getKa();
        double kr = rilData.getKr();
        double kp = rilData.getKp();
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Ka", kaString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Kr", krString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Kp", kpString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        writer.println("</DatiPdp>");
    }

    public void printDatiMisura(Pdo rfo, List<RilData> rilDataList, PrintWriter writer) {
        ExportXmlHelper.printCausaOstativa(rfo, writer);
        RilData first = rilDataList.get(0);
        String potMax = first.getPotMax();
        double ka = rfo.getKa();
        double kr = rfo.getKr();
        double kp = rfo.getKp();
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "PotMax", potMax, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        ExportXmlHelper.printMese(rilDataList, writer, this.giornoFormat, this.itEnergyFormat, new HashSet<String>());
    }

    @Override
    public void printDatiPod(Pdo item, PrintWriter writer) {
        throw new RuntimeException("errore nel flusso dell'applicazione");
    }

    @Override
    public void printDatiMisura(Pdo item, PrintWriter writer, Set<String> banned) {
        throw new RuntimeException("errore nel flusso dell'applicazione");
    }
}

