/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.AbstractMNODatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Misure2GRDatiPodPrinter
extends AbstractMNODatiPodPrinter {
    private final Map<String, String> datiMisura;

    public Misure2GRDatiPodPrinter(RilGiorno rilGiorno, Map<String, String> datiMisura, PrebillingConfiguration configuration, Map<String, String> misuraType, Trattamento trattamento) {
        super(configuration, misuraType, trattamento, rilGiorno);
        this.datiMisura = datiMisura;
    }

    @Override
    public void printDatiMisura(Mno mno, PrintWriter writer, Set<String> banned) {
        String raccolta = mno.getRaccolta();
        ExportXmlHelper.printTag("Raccolta", raccolta, writer);
        String tipoDato = mno.getTipoDato();
        ExportXmlHelper.printTag("TipoDato", tipoDato, writer);
        Map<String, Map<String, String>> datiPod = mno.getDatiPod();
        Map<String, String> dettagli = this.datiMisura == null ? datiPod.get("Misura") : this.datiMisura;
        ExportXmlHelper.printCausaOstativa(mno, writer);
        ExportXmlHelper.printTag("Validato", mno.getValidato(), writer);
        String potMax = StrategyHelper.getPotMaxXml(mno, this.itEnergyFormat);
        ExportXmlHelper.printTag("PotMax", potMax, writer);
        LinkedHashSet<String> toPrintAttivaReattiva = new LinkedHashSet<String>();
        toPrintAttivaReattiva.addAll(ExportXmlHelper.TO_PRINT_ATTIVA_REATTIVA);
        LinkedHashSet<String> toPrintCapacitiva = new LinkedHashSet<String>();
        toPrintCapacitiva.addAll(ExportXmlHelper.TO_PRINT_REATTIVA_CAPACITIVA);
        LinkedHashSet<String> toPrintInduttiva = new LinkedHashSet<String>();
        toPrintInduttiva.addAll(ExportXmlHelper.TO_PRINT_REATTIVA_INDUTTIVA);
        ExportXmlHelper.printGiorno("Ea", this.rilGiorno, ExportXmlHelper.ATTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        ExportXmlHelper.printGiorno("Er", this.rilGiorno, ExportXmlHelper.REATTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        double ka = mno.getKa().doubleValue();
        double kr = mno.getKr().doubleValue();
        double kp = mno.getKp().doubleValue();
        StrategyHelper.newPrintValueMap(dettagli, null, toPrintAttivaReattiva, false, this.itEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
        ExportXmlHelper.printGiorno("Erc", this.rilGiorno, ExportXmlHelper.REATTIVA_CAPACITIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        StrategyHelper.newPrintValueMap(dettagli, null, toPrintCapacitiva, false, this.itEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
        ExportXmlHelper.printGiorno("Eri", this.rilGiorno, ExportXmlHelper.REATTIVA_INDUTTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        StrategyHelper.newPrintValueMap(dettagli, null, toPrintInduttiva, false, this.itEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
    }
}

