/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.RFO2GRDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.classifier.RecordMap;

public class ExportRfo2GRXmlStrategy
extends AbstractExportXmlStrategy<Mno> {
    private RecordMap<String, Mno2GE> pno2gea;
    private RecordMap<String, Mno2GE> pno2ger;
    private RecordMap<String, Mno2GE> pno2gerc;
    private RecordMap<String, Mno2GE> pno2geri;

    public ExportRfo2GRXmlStrategy(TipoFlusso tipo, Funzionalita funzionalita, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(tipo, funzionalita, configuration, reseller, talkManager, folderSuffix);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        this.pno2gea = status.getRfo2gREa();
        this.pno2ger = status.getRfo2gRer();
        this.pno2gerc = status.getRfo2gRerc();
        this.pno2geri = status.getRfo2gReri();
        List<Mno> rfos2gR = status.getRfo2GRXml();
        return this.export(Delibera.D479, rfos2gR, status);
    }

    @Override
    public void printItem(Mno item, ServiceStatus status, PrintWriter writer) {
        Class<?> thisClass = this.getClass();
        String className = thisClass.getSimpleName();
        Map<String, String> misureType = status.getMisureType();
        Date data = item.getDataMisura();
        String codicePod = item.getCodicePod();
        String key = Mno2GE.getKey(codicePod, data);
        Mno2GE pno2geaPod = this.pno2gea.get(key);
        Mno2GE pno2gerPod = this.pno2ger.get(key);
        Mno2GE pno2gercPod = this.pno2gerc.get(key);
        Mno2GE pno2geriPod = this.pno2geri.get(key);
        Map<String, String> datiMisura = item.getDatiPod().get("Misura");
        ExportXmlHelper.fillSegnanti(datiMisura, pno2gercPod, pno2geriPod, this.itEnergyFormat);
        String id = item.getFirstId();
        RilGiorno rilGiorno = ExportXmlHelper.buildRilGiorno(data, "RFO2G", id, pno2geaPod, pno2gerPod, pno2gercPod, pno2geriPod);
        RFO2GRDatiPodPrinter datiPodPrinter = new RFO2GRDatiPodPrinter(rilGiorno, datiMisura, this.configuration, misureType);
        datiPodPrinter.print(className, item, writer);
        MnoResult result = new MnoResult(item, ErroriElaborazione.OK, "");
        status.addPdo2GREsportati(result);
    }
}

