/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.AbstractMNODatiPodPrinter;
import biz.elabor.prebilling.services.xml.d479.DataMisuraTrattamentoVisitor;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class DefaultMnoDatiPodPrinter
extends AbstractMNODatiPodPrinter {
    public DefaultMnoDatiPodPrinter(PrebillingConfiguration configuration, Map<String, String> misuraType) {
        super(configuration, misuraType, null, null);
    }

    @Override
    public void printDatiPod(Mno mno, PrintWriter writer) {
        Date dataMisura = mno.getDataMisura();
        Trattamento trattamento = mno.getTrattamento();
        DataMisuraTrattamentoVisitor visitor = new DataMisuraTrattamentoVisitor(dataMisura, null, writer);
        trattamento.accept(visitor);
        Date dataPrestazione = mno.getDataPrestazione();
        ExportXmlHelper.printTag("DataPrest", dataPrestazione, writer, this.dataFormat);
        String codPratAtt = mno.getCodPratAtt();
        ExportXmlHelper.printTag("CodPrat_SII", codPratAtt, writer);
        this.printDatiPdp(mno, writer);
        if (mno.isForfait()) {
            this.printConsumo(mno, writer);
        } else {
            this.printMisura(mno, writer);
        }
    }

    @Override
    public void printDatiMisura(Mno mno, PrintWriter writer, Set<String> banned) {
        String raccolta = mno.getRaccolta();
        ExportXmlHelper.printTag("Raccolta", raccolta, writer);
        String tipoDato = mno.getTipoDato();
        ExportXmlHelper.printTag("TipoDato", tipoDato, writer);
        if ("S".equals(tipoDato)) {
            String motivazioneStima = mno.getMotivazioneStima();
            ExportXmlHelper.printTag("CausaOstativa", motivazioneStima, writer);
        }
        ExportXmlHelper.printCausaOstativa(mno, writer);
        ExportXmlHelper.printTag("Validato", mno.getValidato(), writer);
        Map<String, String> dettagli = mno.getDatiPod().get("Misura");
        banned.add("tipodato");
        banned.add("raccolta");
        banned.add("validato");
        double ka = StrategyHelper.getK(mno.getKa());
        double kr = StrategyHelper.getK(mno.getKr());
        double kp = StrategyHelper.getK(mno.getKp());
        StrategyHelper.printValueMap(dettagli, null, banned, false, this.itEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
    }
}

