/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.TrattamentoVisitor;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class DataMisuraTrattamentoVisitor
implements TrattamentoVisitor {
    private final Date dataMisura;
    private final RilGiorno rilGiorno;
    private final PrintWriter writer;
    private final DateFormat dataFormat;

    public DataMisuraTrattamentoVisitor(Date dataMisura, RilGiorno rilGiorno, PrintWriter writer) {
        this.dataMisura = dataMisura;
        this.rilGiorno = rilGiorno;
        this.writer = writer;
        this.dataFormat = StrategyHelper.getDataFormat();
    }

    @Override
    public void visitOrario() {
        DateFormat formatter = StrategyHelper.getMeseAnnoFormat();
        String meseAnno = formatter.format(this.dataMisura);
        ExportXmlHelper.printTag("MeseAnno", meseAnno, this.writer);
        if (this.rilGiorno == null) {
            ExportXmlHelper.printTag("DataMisura", this.dataMisura, this.writer, this.dataFormat);
        }
    }

    @Override
    public void visitFasce() {
        ExportXmlHelper.printTag("DataMisura", this.dataMisura, this.writer, this.dataFormat);
    }

    @Override
    public void visitMono() {
        ExportXmlHelper.printTag("DataMisura", this.dataMisura, this.writer, this.dataFormat);
    }
}

