/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.DatiFlussoMisura;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.DatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDatiPodPrinter<T extends DatiFlussoMisura>
implements DatiPodPrinter<T> {
    protected final PrebillingConfiguration configuration;
    private final Map<String, String> misuraType;
    protected final DecimalFormat itEnergyFormat;
    protected final DateFormat giornoFormat;
    protected final DecimalFormat meseFormat;
    protected final DateFormat longDataFormat;
    protected final DateFormat dataFormat;
    protected final DateFormat meseAnnoFormat;

    public abstract void printDatiPod(T var1, PrintWriter var2);

    public abstract void printDatiMisura(T var1, PrintWriter var2, Set<String> var3);

    public AbstractDatiPodPrinter(PrebillingConfiguration configuration, Map<String, String> misuraType) {
        this.configuration = configuration;
        this.misuraType = misuraType;
        this.giornoFormat = StrategyHelper.getGiornoFormat();
        this.meseFormat = StrategyHelper.getMeseNumFormat();
        this.itEnergyFormat = StrategyHelper.getItEnergyFormat();
        this.longDataFormat = StrategyHelper.getFullDateFormat();
        this.dataFormat = StrategyHelper.getDataFormat();
        this.meseAnnoFormat = StrategyHelper.getMeseAnnoFormat();
    }

    @Override
    public void print(String context, T item, PrintWriter writer) {
        String codicePod = item.getCodicePod();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        this.printDatiPod(item, writer);
        writer.println("</DatiPod>");
    }

    public final void printMisura(T item, String potMax, String causaOstativa, RilGiorno rilGiorno, PrintWriter writer) {
        String idTipoMisura = ((DatiFlussoMisura)item).getIdTipoMisura();
        writer.println("<Misura xsi:type=\"" + this.getTipoMisura(idTipoMisura) + "\">");
        ExportXmlHelper.printTag("PotMax", potMax, writer);
        ExportXmlHelper.printTag("CausaOstativa", causaOstativa, writer);
        ExportXmlHelper.printGiorno("Ea", rilGiorno, ExportXmlHelper.ATTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        ExportXmlHelper.printGiorno("Er", rilGiorno, ExportXmlHelper.REATTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        this.printDatiMisura(item, writer, ExportXmlHelper.BANNED_ENERGIA_FASCE_CAPACITIVA_INDUTTIVA);
        ExportXmlHelper.printGiorno("Erc", rilGiorno, ExportXmlHelper.REATTIVA_CAPACITIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        this.printDatiMisura(item, writer, ExportXmlHelper.BANNED_ENERGIA_FASCE_INDUTTIVA_ATTIVA_REATTIVA);
        ExportXmlHelper.printGiorno("Eri", rilGiorno, ExportXmlHelper.REATTIVA_INDUTTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        this.printDatiMisura(item, writer, ExportXmlHelper.BANNED_ENERGIA_FASCE_CAPACITIVA_ATTIVA_REATTIVA);
        writer.println("</Misura>");
    }

    public final void printMisura(T item, PrintWriter writer) {
        String idTipoMisura = ((DatiFlussoMisura)item).getIdTipoMisura();
        writer.println("<Misura xsi:type=\"" + this.getTipoMisura(idTipoMisura) + "\">");
        this.printDatiMisura(item, writer, new HashSet<String>());
        writer.println("</Misura>");
    }

    protected String getTipoMisura(String idTipoMisura) {
        return this.misuraType.get(idTipoMisura);
    }

    protected static Set<String> buildBanned() {
        HashSet<String> banned = new HashSet<String>();
        banned.add("tipodato");
        banned.add("raccolta");
        banned.add("validato");
        banned.add("motivazionestima");
        banned.add("potmax");
        return banned;
    }
}

