/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.AbstractMNODatiPodPrinter;
import biz.elabor.prebilling.services.xml.d479.DataMisuraTrattamentoVisitor;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RTR2GRDatiPodPrinter
extends AbstractMNODatiPodPrinter {
    public RTR2GRDatiPodPrinter(RilGiorno rilGiorno, PrebillingConfiguration configuration, Map<String, String> misuraType) {
        super(configuration, misuraType, null, rilGiorno);
    }

    @Override
    public void printDatiPod(Mno rtr, PrintWriter writer) {
        Date dataMisura = rtr.getDataMisura();
        Trattamento.F.accept(new DataMisuraTrattamentoVisitor(dataMisura, null, writer));
        ExportXmlHelper.printTag("TipoRettifica", rtr.getTipoRettifica(), writer);
        ExportXmlHelper.printTag("DataRilevazione", rtr.getDataRilevazione(), writer, this.dataFormat);
        ExportXmlHelper.printTag("Motivazione", rtr.getMotivazione(), writer);
        ExportXmlHelper.printTag("DataPrest", rtr.getDataPrestazione(), writer, this.dataFormat);
        ExportXmlHelper.printTag("CodPrat_SII", rtr.getCodPratAtt(), writer);
        this.printDatiPdp(rtr, writer);
        String potMax = StrategyHelper.getPotMaxXml(rtr, this.itEnergyFormat);
        this.printMisuraMese(rtr, potMax, writer);
    }

    protected void printMisuraMese(Mno item, String potMax, PrintWriter writer) {
        String idTipoMisura = item.getIdTipoMisura();
        writer.println("<Misura xsi:type=\"" + this.getTipoMisura(idTipoMisura) + "\">");
        ExportXmlHelper.printCausaOstativa(item, writer);
        ExportXmlHelper.printTag("PotMax", potMax, writer);
        ExportXmlHelper.printGiorno("Ea", this.rilGiorno, ExportXmlHelper.ATTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        ExportXmlHelper.printGiorno("Er", this.rilGiorno, ExportXmlHelper.REATTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        this.printDatiMisura(item, writer, ExportXmlHelper.BANNED_ENERGIA_FASCE_CAPACITIVA_INDUTTIVA);
        ExportXmlHelper.printGiorno("Erc", this.rilGiorno, ExportXmlHelper.REATTIVA_CAPACITIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        this.printDatiMisura(item, writer, ExportXmlHelper.BANNED_ENERGIA_FASCE_INDUTTIVA_ATTIVA_REATTIVA);
        ExportXmlHelper.printGiorno("Eri", this.rilGiorno, ExportXmlHelper.REATTIVA_INDUTTIVA_EXTRACTOR, writer, this.giornoFormat, this.itEnergyFormat);
        this.printDatiMisura(item, writer, ExportXmlHelper.BANNED_ENERGIA_FASCE_CAPACITIVA_ATTIVA_REATTIVA);
        writer.println("</Misura>");
    }

    @Override
    public void printDatiMisura(Mno mno, PrintWriter writer, Set<String> banned) {
        HashSet<String> bannedLocal = new HashSet<String>(banned);
        Map<String, String> dettagli = mno.getDatiPod().get("Misura");
        bannedLocal.add("tipodato");
        bannedLocal.add("raccolta");
        bannedLocal.add("validato");
        bannedLocal.add("motivazionestima");
        bannedLocal.add("potmax");
        double ka = mno.getKa().doubleValue();
        double kr = mno.getKr().doubleValue();
        double kp = mno.getKp().doubleValue();
        StrategyHelper.printValueMap(dettagli, null, bannedLocal, false, this.itEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
    }
}

