/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.DefaultExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.util.Date;
import org.homelinux.elabor.structures.classifier.RecordMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public class RNV2GExportXmlHandler
extends DefaultExportXmlHandler {
    @Override
    public ListMap<Delibera, Mno> getRnos(ServiceStatus status) {
        return status.getRnv2GXml();
    }

    @Override
    public RilGiorno getRilGiorno(Mno item, ServiceStatus status) {
        String codicePod = item.getCodicePod();
        Date data = item.getDataMisura();
        String key = Mno2GE.getKey(codicePod, data);
        RecordMap<String, Mno2GE> rnv2gRea = status.getRnv2gRea();
        Mno2GE pnv2geaPod = rnv2gRea.get(key);
        RecordMap<String, Mno2GE> rnv2gRer = status.getRnv2gRer();
        Mno2GE pnv2gerPod = rnv2gRer.get(key);
        RecordMap<String, Mno2GE> rnv2gRerc = status.getRnv2gRerc();
        Mno2GE pnv2gercPod = rnv2gRerc.get(key);
        RecordMap<String, Mno2GE> rnv2gReri = status.getRnv2gReri();
        Mno2GE pnv2geriPod = rnv2gReri.get(key);
        String id = item.getFirstId();
        return ExportXmlHelper.buildRilGiorno(data, "RNV2G", id, pnv2geaPod, pnv2gerPod, pnv2gercPod, pnv2geriPod);
    }

    @Override
    public String getPotMax(Mno mno) {
        return StrategyHelper.getPotMaxXml(mno, this.itEnergyFormat);
    }

    @Override
    public Date getDataPrest(Mno mno) {
        return mno.getDataPrestazione();
    }

    @Override
    public String getCodPratSii(Mno mno) {
        return mno.getCodPratAtt();
    }
}

