/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.DefaultExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.util.Date;
import org.homelinux.elabor.structures.classifier.RecordMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public class RNO2GExportXmlHandler
extends DefaultExportXmlHandler {
    public RNO2GExportXmlHandler() {
        this.itEnergyFormat = StrategyHelper.getItEnergyFormat();
    }

    @Override
    public ListMap<Delibera, Mno> getRnos(ServiceStatus status) {
        return status.getRno2GXml();
    }

    @Override
    public RilGiorno getRilGiorno(Mno item, ServiceStatus status) {
        String codicePod = item.getCodicePod();
        Date data = item.getDataMisura();
        String key = Mno2GE.getKey(codicePod, data);
        RecordMap<String, Mno2GE> rno2gRea = status.getRno2gRea();
        Mno2GE pno2geaPod = rno2gRea.get(key);
        RecordMap<String, Mno2GE> rno2gRer = status.getRno2gRer();
        Mno2GE pno2gerPod = rno2gRer.get(key);
        RecordMap<String, Mno2GE> rno2gRerc = status.getRno2gRerc();
        Mno2GE pno2gercPod = rno2gRerc.get(key);
        RecordMap<String, Mno2GE> rno2gReri = status.getRno2gReri();
        Mno2GE pno2geriPod = rno2gReri.get(key);
        String id = item.getFirstId();
        return ExportXmlHelper.buildRilGiorno(data, "RNO2G", id, pno2geaPod, pno2gerPod, pno2gercPod, pno2geriPod);
    }

    @Override
    public String getPotMax(Mno mno) {
        return StrategyHelper.getPotMaxXml(mno, this.itEnergyFormat);
    }

    @Override
    public Date getDataPrest(Mno mno) {
        return mno.getDataPrestazione();
    }

    @Override
    public String getCodPratSii(Mno mno) {
        return mno.getCodPratAtt();
    }
}

