/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.DefaultOrariManagerXmlSingle;
import biz.elabor.prebilling.services.xml.d479.RFO2GRDatiPodPrinter;
import biz.elabor.prebilling.services.xml.d479.RFODatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class RFO2GManagerXmlSingle
extends DefaultOrariManagerXmlSingle {
    RFO2GManagerXmlSingle() {
    }

    @Override
    public void printDatiPod(String context, Pdo pdo, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer, TalkManager talkManager) throws DataNotFoundException {
        DecimalFormat format = StrategyHelper.getItEnergyFormat();
        String regime = pdo.getRegime();
        if (regime.equals("NR")) {
            RFODatiPodPrinter datiPodPrinter = new RFODatiPodPrinter(configuration, misureType);
            datiPodPrinter.print(context, pdo, writer);
        } else {
            for (String id : pdo.getId()) {
                Mno pdo2gr = misureDao.getPdo2GRXml(id, talkManager);
                Date data = pdo2gr.getDataMisura();
                Mno2GE pno2geaPod = misureDao.getPdo2geaXml(id);
                Mno2GE pno2gerPod = misureDao.getPdo2gerXml(id);
                Mno2GE pno2gercPod = misureDao.getPdo2gercXml(id);
                Mno2GE pno2geriPod = misureDao.getPdo2geriXml(id);
                RilGiorno rilGiorno = ExportXmlHelper.buildRilGiorno(data, "RFO2G", id, pno2geaPod, pno2gerPod, pno2gercPod, pno2geriPod);
                Map<String, String> datiMisura = pdo.getDatiPod().get("Misura");
                ExportXmlHelper.fillSegnanti(datiMisura, pno2gercPod, pno2geriPod, format);
                RFO2GRDatiPodPrinter datiPodPrinter = new RFO2GRDatiPodPrinter(rilGiorno, datiMisura, configuration, misureType);
                datiPodPrinter.print(context, pdo2gr, writer);
            }
        }
    }

    @Override
    public void printDatiPod(String context, Mno mno, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer) {
    }
}

