/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.services.xml.DefaultOrariManagerXmlSingle;
import biz.elabor.prebilling.services.xml.d479.Misure2GRDatiPodPrinter;
import biz.elabor.prebilling.services.xml.d479.PDODatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class PDO2GManagerXmlSingle
extends DefaultOrariManagerXmlSingle {
    PDO2GManagerXmlSingle() {
    }

    @Override
    public void printDatiPod(String context, Pdo pdo, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer, TalkManager talkManager) throws DataNotFoundException {
        String regime = pdo.getRegime();
        if (regime.equals("NR")) {
            PDODatiPodPrinter datiPodPrinter = new PDODatiPodPrinter(configuration, misureType);
            datiPodPrinter.print(context, pdo, writer);
        } else {
            for (String id : pdo.getId()) {
                Mno pdo2gr = misureDao.getPdo2GRXml(id, talkManager);
                Date data = pdo2gr.getDataMisura();
                Mno2GE pno2geaPod = misureDao.getPdo2geaXml(id);
                Mno2GE pno2gerPod = misureDao.getPdo2gerXml(id);
                Mno2GE pno2gercPod = misureDao.getPdo2gercXml(id);
                Mno2GE pno2geriPod = misureDao.getPdo2geriXml(id);
                RilGiorno rilGiorno = ExportXmlHelper.buildRilGiorno(data, "PDO2G", id, pno2geaPod, pno2gerPod, pno2gercPod, pno2geriPod);
                Misure2GRDatiPodPrinter datiPodPrinter = new Misure2GRDatiPodPrinter(rilGiorno, null, configuration, misureType, null);
                datiPodPrinter.print(context, pdo2gr, writer);
            }
        }
    }

    @Override
    public void printDatiPod(String context, Mno mno, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer) {
    }
}

