/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.ManagerXmlSingle;
import biz.elabor.prebilling.services.xml.d479.AbstractFlussoFDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class DefaultSwitchOrariManagerXmlSingle
implements ManagerXmlSingle {
    private DecimalFormat itEnergyFormat;
    private DateFormat longDataFormat;
    private DateFormat dataFormat = StrategyHelper.getDataFormat();

    public DefaultSwitchOrariManagerXmlSingle() {
        this.longDataFormat = StrategyHelper.getFullDateFormat();
        this.itEnergyFormat = StrategyHelper.getItEnergyFormat();
    }

    @Override
    public void printDatiPod(String context, Pdo pdo, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer, TalkManager talkManager) {
    }

    @Override
    public void printDatiPod(String context, Mno mno, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer) {
    }

    @Override
    public void printDatiPod(String context, Snf snf, PrebillingConfiguration configuration, MisureDao misureDao, PrintWriter writer) {
    }

    @Override
    public void printDatiPod(String context, Sof sof, PrebillingConfiguration configuration, MisureDao misureDao, PrintWriter writer) {
        if (sof.getDelibera().isDelibera65()) {
            double ka = sof.getKa().doubleValue();
            double kr = sof.getKr().doubleValue();
            double kp = sof.getKp().doubleValue();
            ExportXmlHelper.printDatiPod(context, sof, configuration, writer, this.itEnergyFormat, this.longDataFormat, this.dataFormat, ka, kr, kp);
        } else {
            AbstractFlussoFDatiPodPrinter<Sof> datiPodPrinter = new AbstractFlussoFDatiPodPrinter<Sof>();
            datiPodPrinter.print(context, sof, writer);
        }
    }
}

