/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import biz.elabor.prebilling.services.volture.SelectVoltureNonOrarieStrategy;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;

public class SelectVoltureNonOrarieStrategyTest
extends TestCase {
    public void testExecute() {
        TestConfiguration configuration = new TestConfiguration();
        boolean crm = configuration.hasCrm();
        TalkManager talkManager = new TalkManager();
        SelectVoltureNonOrarieStrategy strategy = new SelectVoltureNonOrarieStrategy(null, configuration, talkManager);
        ServiceStatus status = SelectVoltureNonOrarieStrategyTest.defineStatus(configuration);
        strategy.execute(status);
        Misure<Mno> vnosCrm = status.getVnosCrm();
        if (crm) {
            SelectVoltureNonOrarieStrategyTest.assertTrue(!vnosCrm.isEmpty());
        } else {
            SelectVoltureNonOrarieStrategyTest.assertTrue(vnosCrm.isEmpty());
        }
    }

    private static ServiceStatus defineStatus(PrebillingConfiguration configuration) {
        TestServiceStatus status = new TestServiceStatus(configuration);
        LinkedHashMap<String, String> datiPdp1 = new LinkedHashMap<String, String>();
        datiPdp1.put("Trattamento", "M");
        datiPdp1.put("Tensione", "100");
        datiPdp1.put("PotContrImp", "1,000");
        datiPdp1.put("PotDisp", "1,000");
        datiPdp1.put("Ka", "1,000");
        datiPdp1.put("Kr", "1,000");
        datiPdp1.put("Kp", "1,000");
        datiPdp1.put("MatrAtt", "MatrAtt1");
        datiPdp1.put("MatrRea", "MatrRea1");
        datiPdp1.put("MatrPot", "MatrPot1");
        datiPdp1.put("CifreAtt", "3");
        datiPdp1.put("CifreRea", "3");
        datiPdp1.put("CifrePot", "3");
        datiPdp1.put("CodiceTariffa", "codTar1");
        datiPdp1.put("ServizioTutela", "S");
        LinkedHashMap<String, String> misure1 = new LinkedHashMap<String, String>();
        misure1.put("TipoDato", "E");
        misure1.put("EaM", "30,125");
        misure1.put("EaF1", "11,001");
        misure1.put("EaF2", "11,002");
        misure1.put("EaF3", "11,003");
        misure1.put("ErM", "30,125");
        misure1.put("ErF1", "11,001");
        misure1.put("ErF2", "11,002");
        misure1.put("ErF3", "11,003");
        misure1.put("PotM", "30,125");
        misure1.put("PotF1", "11,001");
        misure1.put("PotF2", "11,002");
        misure1.put("PotF3", "11,003");
        LinkedHashMap<String, String> datiPdp2 = new LinkedHashMap<String, String>();
        datiPdp2.put("Trattamento", "F");
        datiPdp2.put("Tensione", "200");
        datiPdp2.put("PotContrImp", "2,000");
        datiPdp2.put("PotDisp", "2,000");
        datiPdp2.put("Ka", "2,000");
        datiPdp2.put("Kr", "2,000");
        datiPdp2.put("Kp", "2,000");
        datiPdp2.put("MatrAtt", "matratt2");
        datiPdp2.put("MatrRea", "matrrea2");
        datiPdp2.put("MatrPot", "matrpot2");
        datiPdp2.put("CifreAtt", "6");
        datiPdp2.put("CifreRea", "6");
        datiPdp2.put("CifrePot", "6");
        datiPdp2.put("CodiceTariffa", "codTar2");
        datiPdp2.put("ServizioTutela", "S");
        LinkedHashMap<String, String> misure2 = new LinkedHashMap<String, String>();
        misure2.put("TipoDato", "E");
        misure2.put("EaM", "22,125");
        misure2.put("EaF1", "22,001");
        misure2.put("EaF2", "22,002");
        misure2.put("EaF3", "22,003");
        misure2.put("ErM", "30,125");
        misure2.put("ErF1", "22,001");
        misure2.put("ErF2", "22,002");
        misure2.put("ErF3", "22,003");
        misure2.put("PotM", "30,125");
        misure2.put("PotF1", "22,001");
        misure2.put("PotF2", "22,002");
        misure2.put("PotF3", "22,003");
        LinkedHashMap<String, String> datiPdp3 = new LinkedHashMap<String, String>();
        datiPdp3.put("Trattamento", "M");
        datiPdp3.put("Tensione", "300");
        datiPdp3.put("PotContrImp", "3,000");
        datiPdp3.put("PotDisp", "3,000");
        datiPdp3.put("Ka", "3,00");
        datiPdp3.put("Kr", "3,000");
        datiPdp3.put("Kp", "3,000");
        datiPdp3.put("MatrAtt", "matratt3");
        datiPdp3.put("MatrRea", "matrrea3");
        datiPdp3.put("MatrPot", "matrpot3");
        datiPdp3.put("CifreAtt", "6");
        datiPdp3.put("CifreRea", "6");
        datiPdp3.put("CifrePot", "6");
        datiPdp3.put("CodiceTariffa", "codTar3");
        datiPdp3.put("ServizioTutela", "MT");
        LinkedHashMap<String, String> misure3 = new LinkedHashMap<String, String>();
        misure3.put("TipoDato", "E");
        misure3.put("EaM", "33,125");
        misure3.put("EaF1", "33,001");
        misure3.put("EaF2", "33,002");
        misure3.put("EaF3", "33,003");
        misure3.put("ErM", "30,125");
        misure3.put("ErF1", "33,001");
        misure3.put("ErF2", "33,002");
        misure3.put("ErF3", "33,003");
        misure3.put("PotM", "30,125");
        misure3.put("PotF1", "33,001");
        misure3.put("PotF2", "33,002");
        misure3.put("PotF3", "33,003");
        Date dataMisura1 = CalendarTools.getDate(2016, Month.SEPTEMBER, 24);
        Date dataMisura2 = CalendarTools.getDate(2016, Month.SEPTEMBER, 5);
        LinkedHashMap<String, Map<String, String>> datiPod1 = new LinkedHashMap<String, Map<String, String>>();
        datiPod1.put("DatiPdp", datiPdp1);
        datiPod1.put("Misura", misure1);
        LinkedHashMap<String, Map<String, String>> datiPod2 = new LinkedHashMap<String, Map<String, String>>();
        datiPod2.put("DatiPdp", datiPdp2);
        datiPod2.put("Misura", misure2);
        LinkedHashMap<String, LinkedHashMap<String, String>> datiPod3 = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        datiPod3.put("DatiPdp", datiPdp3);
        datiPod3.put("Misura", misure3);
        Misura misura1 = PrebillingTestHelper.newMisura(dataMisura1, false, 3);
        Mno vno1 = new Mno(null, null, "pod1", misura1, null, null, "codContrDisp", "CodPratAtt1", null, null, null, datiPod1, "", "", null, null, null, "", "", null, "");
        Misura misura2 = PrebillingTestHelper.newMisura(dataMisura2, false, 3);
        Mno vno2 = new Mno(null, null, "pod2", misura2, null, null, "codContrDisp", "CodPratAtt2", null, null, null, datiPod2, "", "", null, null, null, "", "", null, "");
        Misure<Mno> vnos = new Misure<Mno>("vno");
        vnos.add(vno1);
        vnos.add(vno2);
        status.setVno(vnos);
        DefaultListMapKey<String, PraticaVolo> piv = new DefaultListMapKey<String, PraticaVolo>();
        SpecificaTecnica voltura = new SpecificaTecnica("1", new Date(0L));
        piv.add(new PraticaVolo("pod1", "reseller", voltura, null, null, null, 0));
        status.setPiv(piv);
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        status.setResellers(resellers);
        DefaultPodMap podMap = new DefaultPodMap();
        status.setPodMap(podMap);
        Misure<Mno> pdo2grv = new Misure<Mno>("pdo2grv");
        status.setPdo2GRV(pdo2grv);
        return status;
    }
}

