/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.StatusManager;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.AbstractD65CsvService;
import biz.elabor.prebilling.services.common.AbstractExportNoCrmService;
import biz.elabor.prebilling.services.common.D65CrmService;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.switched.D65SnfCsvService;
import biz.elabor.prebilling.services.switched.VoltureIVStatoPodHandler;
import biz.elabor.prebilling.services.volture.SnfListBuilder;
import biz.elabor.prebilling.services.volture.VolturaIVResult;
import biz.elabor.prebilling.services.volture.VoltureIVStatoPodIH;
import biz.elabor.prebilling.services.volture.model.VolturaIV;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.BasicKeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ExportVoltureIVStrategy
extends AbstractExportNoCrmService
implements ServiceStrategy {
    private static final String VOLTURE_IV = "voltureiv";
    private final TalkManager talkManager;
    private final AbstractD65CsvService d65CsvService;
    private final D65CrmService d65CrmService;
    private final VoltureIVStatoPodHandler statoPodHandler;

    public ExportVoltureIVStrategy(MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(configuration);
        this.talkManager = talkManager;
        this.d65CsvService = new D65SnfCsvService("SE1", configuration, talkManager);
        this.d65CrmService = new D65CrmService(Funzionalita.VOLTURE, configuration, talkManager);
        VoltureIVStatoPodIH initHandler = new VoltureIVStatoPodIH();
        this.statoPodHandler = new VoltureIVStatoPodHandler(misureDao, initHandler);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        SafeMap<String, Reseller> resellers = status.getResellers();
        try {
            ok = true;
            String idEsecuzione = status.getIdEsecuzione();
            for (Map.Entry<String, List<VolturaIV>> volturaEntry : status.getVoltureIV().entrySet()) {
                String azienda = volturaEntry.getKey();
                List<VolturaIV> volture = volturaEntry.getValue();
                Reseller reseller = (Reseller)resellers.get(azienda);
                List<Snf> d65 = this.buildD65(reseller, volture, status);
                if (this.hasCrm(reseller)) {
                    LinkedHashMap map = new LinkedHashMap();
                    SnfListBuilder builder = new SnfListBuilder();
                    StructuresHelper.buildCollectionsMap(map, d65, builder);
                    for (Map.Entry snfEntry : map.entrySet()) {
                        String codicePod = (String)snfEntry.getKey();
                        List snfList = (List)snfEntry.getValue();
                        ok &= this.d65CrmService.export(snfList, "Vol_IV_pod", codicePod, "VT1", true, (StatusManager)status);
                    }
                    continue;
                }
                String timestamp = this.timestampFormat.format(new Date());
                String fileName = "Volture-IV-d65-dati-funzionali-nonorari-" + azienda + "-" + timestamp + ".csv";
                File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, Funzionalita.VOLTURE);
                File file = new File(folder, fileName);
                if (d65.isEmpty()) continue;
                ok &= this.d65CsvService.export(azienda, d65, file, status);
            }
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            Message sentence = new Message(VOLTURE_IV, message);
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private List<Snf> buildD65(Reseller reseller, List<VolturaIV> volture, ServiceStatus status) {
        ArrayList<Snf> d65 = new ArrayList<Snf>();
        for (VolturaIV voltura : volture) {
            ErroriElaborazione errore;
            String descrizione;
            Snf snf = ExportVoltureIVStrategy.buildD65(voltura);
            String azienda = voltura.getCodiceReseller();
            StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
            try {
                if (reseller.isHandleStato()) {
                    this.statoPodHandler.handleStato(snf, transaction);
                }
                d65.add(snf);
                VolturaIVResult result = new VolturaIVResult(voltura, ErroriElaborazione.OK, "");
                status.addVolturaIVElaborata(result);
            }
            catch (StatoPodCheckException | DataNotFoundException exc) {
                descrizione = this.handleKeyException(exc);
                errore = StrategyHelper.getErroreElaborazione(exc);
                this.statoPodHandler.addSospeso(transaction, snf, errore, descrizione);
            }
            catch (PraticaAnnullataException exc) {
                descrizione = this.handleKeyException(exc);
                errore = StrategyHelper.getErroreElaborazione(exc);
                this.statoPodHandler.addObsoleto(transaction, snf, errore, descrizione);
            }
            String codicePod = voltura.getCodicePod();
            transaction.commit(codicePod);
        }
        return d65;
    }

    private String handleKeyException(BasicKeyException exc) {
        String message = exc.getMessage();
        String key = exc.getKey();
        Message sentence = new Message(VOLTURE_IV, message);
        sentence.addParam(key);
        this.talkManager.addSentence(sentence);
        return this.talkManager.getMessage(sentence);
    }

    private static Snf buildD65(VolturaIV voltura) {
        String azienda = voltura.getCodiceReseller();
        String codicePod = voltura.getCodicePod();
        Date dataVoltura = voltura.getSpecificaTecnica().getData();
        String codPratAtt = voltura.getCodPratAtt();
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> datiPdp = new LinkedHashMap<String, String>();
        datiPdp.put("Trattamento", "F");
        datiPdp.put("Ka", "1");
        datiPdp.put("Kr", "1");
        datiPdp.put("Kp", "1");
        datiPdp.put("CifreAtt", "");
        datiPdp.put("CifreRea", "");
        datiPdp.put("CifrePot", "");
        datiPdp.put("GruppoMis", "SI");
        datiPdp.put("Forfait", "NO");
        datiPod.put("DatiPdp", datiPdp);
        String id = voltura.getId().iterator().next();
        return new Snf(id, "D65", codicePod, null, null, null, dataVoltura, codPratAtt, azienda, null, datiPod, null, "FLUSSI_INTERNI");
    }

    private boolean hasCrm(Reseller reseller) {
        return this.configuration.hasCrm() && reseller.isCrm();
    }
}

