/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.ExtendedMno;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisuraNonorariaPod;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.riallineamento.RiallMno;
import biz.elabor.prebilling.services.volture.AbstractExportVoltureNoCrmStrategy;
import biz.elabor.prebilling.services.volture.VnoStatoPodHandler;
import biz.elabor.prebilling.services.volture.model.Voltura;
import biz.elabor.prebilling.util.DefaultMapWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class ExportVnoNoCrmStrategy
extends AbstractExportVoltureNoCrmStrategy
implements ServiceStrategy {
    private final Funzionalita funzionalita;
    private final VnoStatoPodHandler statoPodHandler;
    private Map<String, PrintWriter> fileMap;

    public ExportVnoNoCrmStrategy(Funzionalita funzionalita, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(funzionalita, configuration, talkManager);
        this.funzionalita = funzionalita;
        this.statoPodHandler = new VnoStatoPodHandler(misureDao);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            String idEsecuzione = status.getIdEsecuzione();
            SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
            this.statoPodHandler.check(prestazioni);
            this.fileMap = new HashMap<String, PrintWriter>();
            Map<String, Misure<Voltura>> vnos = status.getVnoNoCrm();
            ArrayList<ExtendedMno> listToExportDisallineati = new ArrayList<ExtendedMno>();
            Map<String, List<MisuraNonorariaPod>> misureVoltura = this.findToExport(vnos, status);
            ok = this.exportVnos(misureVoltura, "Voltura-D65-", "export.vno.strategy", status);
            PodMap podMap = status.getPodMap();
            ok &= this.findToExportDisallineamenti(vnos, podMap, listToExportDisallineati);
            ok &= this.exportDisallineamenti(listToExportDisallineati, idEsecuzione);
            this.closeWriters();
        }
        catch (SegnaleNotHandledException exc) {
            Warning sentence = new Warning("export.volture.no.crm", "segnale.nothandled");
            sentence.setCss("alert-danger");
            Prestazione prestazione = exc.getPrestazione();
            sentence.addParam(prestazione.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (PrestazioneNotFoundException exc) {
            Warning sentence = new Warning("export.volture.no.crm", "prestazione.notfound");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void closeWriters() {
        for (PrintWriter writer : this.fileMap.values()) {
            writer.close();
        }
    }

    private boolean findToExportDisallineamenti(Map<String, Misure<Voltura>> voltureNOCrm, PodMap podMap, List<ExtendedMno> listToExportDisallineati) {
        boolean ok = true;
        for (Map.Entry<String, Misure<Voltura>> entry : voltureNOCrm.entrySet()) {
            String aziendaId = entry.getKey();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "select disallineati azienda: " + aziendaId);
            Misure<Voltura> misure = entry.getValue();
            for (List list : misure) {
                for (Voltura voltura : list) {
                    MisuraPod vno = voltura.getMisuraPod();
                    String codicePod = vno.getCodicePod();
                    PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
                    Date dataMisura = vno.getDataMisura();
                    Date dataVoltura = vno.getDataVoltura();
                    String pivaDistributoreVolture = this.configuration.getPivaDistributoreVoltureSpeciale();
                    String getpIvaDistributore = vno.getPivaDistributore();
                    if (pivaDistributoreVolture.equals(getpIvaDistributore) && !dataMisura.equals(dataVoltura)) continue;
                    try {
                        Pod pod = podMap.get(codicePod);
                        Set<String> tarDisDom = this.configuration.getTarDisDom();
                        boolean checkReattiva = StrategyHelper.checkReattiva(pod, tarDisDom);
                        RiallMno vnoRial = new RiallMno(vno, !checkReattiva);
                        StrategyHelper.checkDisallineatoNoCrm(pod, vnoRial, listToExportDisallineati);
                    }
                    catch (DataNotFoundException e2) {
                        String message = e2.getMessage();
                        String key = e2.getKey();
                        Warning sentence = new Warning("export.volture.no.crm", message);
                        sentence.setCss("alert-danger");
                        sentence.addParam(key);
                        this.talkManager.addSentence(sentence);
                    }
                }
            }
        }
        return ok;
    }

    private boolean exportDisallineamenti(List<ExtendedMno> listToExportDisallineati, String idEsecuzione) {
        boolean ok = true;
        if (!listToExportDisallineati.isEmpty()) {
            for (ExtendedMno toExport : listToExportDisallineati) {
                Pod pod = toExport.getPod();
                MisuraNonoraria vno = toExport.getVno();
                String azienda = pod.getAzienda();
                PrebillingContext.setContext(this.getClass().getSimpleName(), "export disallineati azienda: " + azienda);
                File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
                PrintWriter writer = this.fileMap.get(azienda);
                if (writer == null) {
                    Date date = new Date();
                    String dateStr = this.timestampFormat.format(date);
                    String fileName = "riallineamento-volture-nocrm-" + azienda + "-" + dateStr + ".txt";
                    File file = new File(folder, fileName);
                    try {
                        writer = new PrintWriter(file);
                        int lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
                        GestFile16Helper.printGestFile16Header(writer, "", lunghezzaMatricola);
                        this.fileMap.put(azienda, writer);
                        ExportVnoNoCrmStrategy.exportDisallineato(pod, writer, vno, "5", "1", this.configuration);
                    }
                    catch (FileNotFoundException e2) {
                        Warning sentence = new Warning("export.vno.strategy", "file.createFailed");
                        sentence.setCss("alert-danger");
                        sentence.addParam(file.getAbsolutePath());
                        this.talkManager.addSentence(sentence);
                        ok = false;
                    }
                    continue;
                }
                ExportVnoNoCrmStrategy.exportDisallineato(pod, writer, vno, "5", "1", this.configuration);
            }
        }
        return ok;
    }

    private static void exportDisallineato(Pod pod, PrintWriter writer, MisuraNonoraria mno, String tipoRec, String cdEsecuz, PrebillingConfiguration configuration) {
        String[] matrAnte = new String[]{mno.getMatricolaAtt(), mno.getMatricolaRea(), mno.getMatricolaPot()};
        Misura misAnte = mno.getMisura();
        DefaultMapWriter mapWriter = new DefaultMapWriter();
        GestFile16Helper.write(pod, false, matrAnte, misAnte, mno, tipoRec, cdEsecuz, mapWriter, configuration);
        mapWriter.flush(writer);
    }

    @Override
    protected void handleMisura(Voltura voltura, boolean handleStato, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        if (handleStato) {
            MisuraPod vno = voltura.getMisuraPod();
            String codicePod = vno.getCodicePod();
            PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, transaction);
            String prestazione = pratica.getCodicePrestazione();
            String cpGestore = pratica.getCodPratAtt();
            Date dataVoltura = vno.getDataVoltura();
            Date dataMisura = vno.getDataMisura();
            this.statoPodHandler.handleStato(vno, prestazione, cpGestore, dataVoltura, dataMisura, transaction);
        }
    }
}

