/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.riallineamento.RiallMno;
import biz.elabor.prebilling.services.volture.VnoStatoPodHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import biz.elabor.prebilling.util.DefaultMapWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.ValueNotHandledException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ExportVnoCrmStrategy
implements ServiceStrategy {
    private PrebillingConfiguration configuration;
    private TalkManager talkManager;
    private Map<String, PrintWriter> fileMap;
    private Funzionalita funzionalita;
    private VnoStatoPodHandler statoPodHandler;
    private final DateFormat timestampFormat;
    private final DecimalFormat usEnergyFormat;
    private final DateFormat dataFormat;
    private final DateFormat longDataFormat;

    public ExportVnoCrmStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.statoPodHandler = new VnoStatoPodHandler(misureDao);
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
        this.usEnergyFormat = StrategyHelper.getUsEnergyFormat();
        this.dataFormat = StrategyHelper.getDataFormat();
        this.longDataFormat = StrategyHelper.getFullDateFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        PodMap podMap = status.getPodMap();
        try {
            SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
            this.statoPodHandler.check(prestazioni);
            this.fileMap = new HashMap<String, PrintWriter>();
            Misure<Mno> mapVnos = status.getVnosCrm();
            ok = true;
            for (Map.Entry entry : mapVnos.entrySet()) {
                String codicePod = (String)entry.getKey();
                List vnos = (List)entry.getValue();
                try {
                    StatusTransaction transaction = new StatusTransaction(null, status, this.configuration);
                    ok &= this.execute(transaction, podMap, codicePod, vnos);
                    transaction.commit(codicePod);
                }
                catch (RuntimeException exc) {
                    String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.volture.crm", this.talkManager, status);
                    status.addVnoSospesi(vnos, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                }
            }
            this.closeWriters();
        }
        catch (SegnaleNotHandledException exc) {
            Warning sentence = new Warning("export.volture.crm", "segnale.nothandled");
            sentence.setCss("alert-danger");
            Prestazione prestazione = exc.getPrestazione();
            sentence.addParam(prestazione.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (PrestazioneNotFoundException exc) {
            Warning sentence = new Warning("export.volture.crm", "prestazione.notfound");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private boolean execute(StatusTransaction transaction, PodMap podMap, String codice, List<Mno> vnos) {
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
        boolean ok = true;
        try {
            Pod pod = podMap.get(codice);
            String azienda = pod.getAzienda();
            transaction.setAzienda(azienda);
            if (pod.isAttesaSnm()) {
                Warning sentence = new Warning("export.volture.crm", "attesa.snm");
                sentence.addParam(codice);
                sentence.setCss("alert-warning");
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                transaction.addVnoSospesi(vnos, ErroriElaborazione.INATTESA_SNM, descrizione);
            } else {
                String idEsecuzione = transaction.getStatus().getIdEsecuzione();
                ArrayList<Mno> listToExportVolture = new ArrayList<Mno>();
                ok &= this.findToExportVolturaPod(pod, vnos, listToExportVolture, transaction);
                ArrayList<MisuraNonoraria> listToExportDisallineati = new ArrayList<MisuraNonoraria>();
                ok &= this.findToExportDisallineamenti(pod, vnos, listToExportDisallineati);
                ok &= ExportVnoCrmStrategy.exportVolturaPod("vno-pod", pod, listToExportVolture, transaction, this.funzionalita, this.configuration, this.usEnergyFormat, this.timestampFormat, this.longDataFormat, this.dataFormat, this.talkManager, idEsecuzione);
                ExportVnoCrmStrategy.count(transaction, listToExportVolture);
                ok &= this.exportDisallineamenti(pod, listToExportDisallineati, idEsecuzione);
            }
        }
        catch (DataNotFoundException e2) {
            String message = e2.getMessage();
            String key = e2.getKey();
            Warning sentence = new Warning("export.vno.strategy", message);
            sentence.setCss("alert-danger");
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            transaction.addVnoSospesi(vnos, ErroriElaborazione.POD_NOTFOUND, descrizione);
        }
        return ok;
    }

    private static void count(StatusTransaction transaction, List<Mno> listToExportVolture) {
        for (Mno mno : listToExportVolture) {
            transaction.count(mno.getCodiceFlusso());
        }
    }

    private void closeWriters() {
        for (PrintWriter writer : this.fileMap.values()) {
            writer.close();
        }
    }

    private boolean findToExportDisallineamenti(Pod pod, List<Mno> vnos, List<MisuraNonoraria> listToExportDisallineati) {
        for (Mno vno : vnos) {
            if (!this.checkVoltura(vno)) continue;
            Set<String> tarDisDom = this.configuration.getTarDisDom();
            boolean checkReattiva = StrategyHelper.checkReattiva(pod, tarDisDom);
            RiallMno vnoRial = new RiallMno(vno, !checkReattiva);
            StrategyHelper.checkDisallineato(pod, vnoRial, listToExportDisallineati);
        }
        return true;
    }

    private boolean exportDisallineamenti(Pod pod, List<MisuraNonoraria> listToExportDisallineati, String idEsecuzione) {
        boolean ok = true;
        if (!listToExportDisallineati.isEmpty()) {
            String azienda = pod.getAzienda();
            File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
            PrintWriter writer = this.fileMap.get(azienda);
            if (writer == null) {
                Date date = new Date();
                String dateStr = this.timestampFormat.format(date);
                String fileName = "riallineamento-volture-crm-" + azienda + "-" + dateStr + ".txt";
                File file = new File(folder, fileName);
                try {
                    writer = new PrintWriter(file);
                    int lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
                    GestFile16Helper.printGestFile16Header(writer, "", lunghezzaMatricola);
                    this.fileMap.put(azienda, writer);
                    this.exportVnosDisallineati(pod, listToExportDisallineati, writer);
                }
                catch (FileNotFoundException e2) {
                    Warning sentence = new Warning("export.vno.strategy", "file.createFailed");
                    sentence.setCss("alert-danger");
                    sentence.addParam(file.getAbsolutePath());
                    this.talkManager.addSentence(sentence);
                    ok = false;
                }
            } else {
                this.exportVnosDisallineati(pod, listToExportDisallineati, writer);
            }
        }
        return ok;
    }

    private void exportVnosDisallineati(Pod pod, List<MisuraNonoraria> listToExportDisallineati, PrintWriter writer) {
        for (MisuraNonoraria vno : listToExportDisallineati) {
            String matricolaAtt = vno.getMatricolaAtt();
            String matricolaRea = vno.getMatricolaRea();
            String matricolaPot = vno.getMatricolaPot();
            String[] matrAnte = new String[]{matricolaAtt, matricolaRea, matricolaPot};
            Misura misAnte = vno.getMisura();
            DefaultMapWriter mapWriter = new DefaultMapWriter();
            GestFile16Helper.write(pod, false, matrAnte, misAnte, vno, "5", "1", mapWriter, this.configuration);
            mapWriter.flush(writer);
        }
    }

    private boolean findToExportVolturaPod(Pod pod, List<Mno> vnos, List<Mno> listToExport, StatusTransaction transaction) {
        SafeMap<String, Reseller> resellers = transaction.getResellers();
        for (Mno vno : vnos) {
            String azienda = pod.getAzienda();
            try {
                Reseller reseller = (Reseller)resellers.get(azienda);
                StrategyHelper.handleKX(pod, vno);
                boolean handleStato = reseller.isHandleStato();
                this.handle(listToExport, vno, pod, azienda, transaction, handleStato);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("export.vno.strategy", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                MnoResult result = new MnoResult(vno, errore, descrizione);
                transaction.addVnoSospeso(result);
            }
        }
        return true;
    }

    public static boolean exportVolturaPod(String prefix, Pod pod, List<Mno> listToExportVolture, StatusTransaction transaction, Funzionalita funzionalita, PrebillingConfiguration configuration, DecimalFormat usEnergyFormat, DateFormat timestampFormat, DateFormat longDateFormat, DateFormat dateFormat, TalkManager talkManager, String idEsecuzione) {
        boolean ok = true;
        if (!listToExportVolture.isEmpty()) {
            Mno vno = listToExportVolture.get(0);
            String codContrDisp = vno.getCodContrDisp();
            File folder = ConfigurationHelper.getMiddlewareTmpFolder(configuration, idEsecuzione, funzionalita);
            folder.mkdirs();
            String dateStr = timestampFormat.format(new Date());
            String codice = pod.getCodice();
            String fileName = String.valueOf(prefix) + "-" + codice + "-" + dateStr + ".xml";
            File file = new File(folder, fileName);
            try {
                PrintWriter writer = new PrintWriter(file);
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                writer.println("<FlussoMisure xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D65\">");
                writer.println("<CodProcesso>VT1</CodProcesso>");
                writer.println("<IdentificativiFlusso>");
                writer.println("<CodContrDisp>" + codContrDisp + "</CodContrDisp>");
                writer.println("</IdentificativiFlusso>");
                ExportVnoCrmStrategy.exportVnos(pod, listToExportVolture, writer, transaction, configuration, usEnergyFormat, longDateFormat, dateFormat);
                writer.print("</FlussoMisure>");
                writer.close();
            }
            catch (FileNotFoundException exc) {
                Warning sentence = new Warning("export.volture.crm", "file.createFailed");
                sentence.setCss("alert-danger");
                sentence.addParam(exc.getMessage());
                talkManager.addSentence(sentence);
                ok = false;
            }
        }
        return ok;
    }

    private static void exportVnos(Pod pod, List<Mno> listToExport, PrintWriter writer, StatusTransaction transaction, PrebillingConfiguration configuration, DecimalFormat usEnergyFormat, DateFormat longDateFormat, DateFormat dateFormat) {
        for (Mno vno : listToExport) {
            Set<String> banned = StrategyHelper.buildBanned(pod, vno);
            Date dataVoltura = vno.getDataVoltura();
            boolean truncateEnergy = configuration.isTrunking();
            Map<String, Double> lastMap = ExportXmlHelper.getLastMap(pod);
            vno.setPotDisponibile(pod.getPotDisponibile());
            vno.setPotContrattuale(pod.getPotImp());
            StrategyHelper.fixPotenza(vno);
            StrategyHelper.printDatiPod(vno, lastMap, dataVoltura, banned, truncateEnergy, usEnergyFormat, configuration, writer, longDateFormat, dateFormat);
            String azienda = pod.getAzienda();
            vno.setCdaziend(azienda);
            MnoResult result = new MnoResult(vno, ErroriElaborazione.OK, "");
            transaction.addVnoElaborato(result);
            Date dateBefore = CalendarTools.previousDay(dataVoltura);
            MisuraMno lettura = new MisuraMno(pod, vno, dateBefore);
            transaction.addLettura(lettura);
        }
    }

    private void handle(List<Mno> vnos, Mno vno, Pod pod, String azienda, StatusTransaction transaction, boolean handleStato) {
        if (this.checkVoltura(vno)) {
            try {
                ExportVnoCrmStrategy.checkCottimi(vno);
                if (handleStato) {
                    String codicePod = vno.getCodicePod();
                    PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, transaction);
                    String codicePrestazione = pratica.getCodicePrestazione();
                    String cpGestore = pratica.getCodPratAtt();
                    MisuraMno misuraMno = new MisuraMno(pod, vno);
                    Date dataVoltura = vno.getDataVoltura();
                    Date dataMisura = vno.getDataMisura();
                    this.statoPodHandler.handleStato(misuraMno, codicePrestazione, cpGestore, dataVoltura, dataMisura, transaction);
                }
                vno.setCdaziend(azienda);
                vnos.add(vno);
            }
            catch (ValueNotHandledException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("export.volture.crm", message);
                sentence.addParam(vno.getCodicePod());
                sentence.setCss("alert-warning");
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                transaction.addVnoEscluso(new MnoResult(vno, errore, descrizione));
            }
            catch (DataNotFoundException e2) {
                String message = e2.getMessage();
                String key = e2.getKey();
                Message sentence = new Message("export.volture.crm", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(e2);
                transaction.addVnoSospeso(new MnoResult(vno, errore, descrizione));
            }
            catch (StatoPodCheckException e3) {
                throw new RuntimeException(e3);
            }
            catch (PraticaAnnullataException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("export.volture.crm", message);
                sentence.addParam(key);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                MnoResult result = new MnoResult(vno, errore, descrizione);
                transaction.addVnoObsoleto(result);
            }
        } else {
            Date dataMisura = vno.getDataMisura();
            Date dataVoltura = vno.getDataVoltura();
            String descrizione = "data misura diversa da data voltura: " + this.dataFormat.format(dataMisura) + " != " + this.dataFormat.format(dataVoltura);
            MnoResult result = new MnoResult(vno, ErroriElaborazione.DATA_NONVALIDA_DISTRIBUTORE, descrizione);
            transaction.addVnoSospeso(result);
        }
    }

    public static void checkCottimi(Mno vno) throws ValueNotHandledException {
        Map<String, String> mappaDettagli = vno.getDatiPod().get("DatiPdp");
        if (mappaDettagli.get("GruppoMis").equals("NO")) {
            throw new ValueNotHandledException("gruppomisura", ErroriElaborazione.NO_GRUPPO_MISURA.ordinal());
        }
        if (mappaDettagli.get("Forfait").equals("SI")) {
            throw new ValueNotHandledException("forfait", ErroriElaborazione.FORFAIT.ordinal());
        }
    }

    private boolean checkVoltura(Mno vno) {
        String pivaDistributoreVolture = this.configuration.getPivaDistributoreVoltureSpeciale();
        Date dataMisura = vno.getDataMisura();
        Date dataVoltura = vno.getDataVoltura();
        String pivaDistributore = vno.getPivaDistributore();
        return !vno.getDelibera().isDelibera65() || dataMisura.equals(dataVoltura) || !pivaDistributoreVolture.equals(pivaDistributore);
    }
}

