/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.AbstractPrestazioneStatoPodHandler;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public abstract class AbstractVolturaSPH
extends AbstractPrestazioneStatoPodHandler<MisuraPod> {
    private static final List<String> VNO = Arrays.asList("VNO");
    private static final List<String> PNO = Arrays.asList("PNO");

    public AbstractVolturaSPH(MisureDao misureDao) {
        super("E", misureDao);
    }

    protected Date getDataVoltura(MisuraPod current) {
        return current.getDataVoltura();
    }

    public void check(SafeListMap<String, Prestazione> prestazioni) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        HashMap<String, List<String>> mappaPrestazioni = new HashMap<String, List<String>>();
        for (String codicePrestazione : StrategyHelper.VOLTURE_CDUNIPRE_LIST) {
            mappaPrestazioni.put(codicePrestazione, codicePrestazione.startsWith("V") ? VNO : PNO);
        }
        this.check(prestazioni, mappaPrestazioni);
    }
}

