/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.TariffaApplicazione;
import biz.elabor.prebilling.services.common.IncoherentKException;
import biz.elabor.prebilling.services.common.TariffeAccumulator;
import biz.elabor.prebilling.services.tariffe.FasceManager;
import biz.elabor.prebilling.services.tariffe.MonorarioManager;
import biz.elabor.prebilling.services.tariffe.SmisException;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TipoCalcoloManager;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;

public enum TipoCalcolo {
    MONORARIO(new MonorarioManager()),
    FASCE(new FasceManager());

    private TipoCalcoloManager manager;

    private TipoCalcolo(TipoCalcoloManager manager) {
        this.manager = manager;
    }

    public TariffeAccumulator getAccumulator(RilMese rilMese, CalendarioFasceMensile calendarioFasce, double coeffUM, Date startDate, double qtconfla, double kAttiva, double[] prezziDefault, boolean perdite, double coeffPerdite, double emtaruni, double emspread, double emspreneg, List<Mno> mnoList) throws InvalidCurvaRilevazioniException, InvalidCurvaIndiciException, IncoherentKException, SmisException {
        return this.manager.getAccumulator(rilMese, calendarioFasce, coeffUM, startDate, qtconfla, kAttiva, prezziDefault, perdite, coeffPerdite, emtaruni, emspread, emspreneg, mnoList);
    }

    public void printSommaImportiOrari(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printSommaImportiOrari(tariffa, label, format, writer);
    }

    public void printSommaImportiOrari(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printSommaImportiOrari(tariffa, label, format, writer);
    }

    public void printSommaConsumi(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printSommaConsumi(tariffa, label, format, writer);
    }

    public void printSommaConsumiEffettivi(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printSommaConsumiEffettivi(tariffa, label, format, writer);
    }

    public void printSommaConsumiCompl(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printSommaConsumiCompl(tariffa, label, format, writer);
    }

    public void printSommaConsumi(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printSommaConsumi(tariffa, label, format, writer);
    }

    public void printPrezzoMedioPonderatoNetto(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printPrezzoMedioPonderatoNetto(tariffa, label, format, writer);
    }

    public void printPrezzoMedioPonderatoNetto(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printPrezzoMedioPonderatoNetto(tariffa, label, format, writer);
    }

    public void printPrezzoMedioPonderatoPerdite(TariffaMultiApplicazione firstTariffa, String label, DecimalFormat format, PrintWriter writer) {
        this.manager.printPrezzoMedioPonderatoPerdite(firstTariffa, label, format, writer);
    }

    public void printFascia(DettaglioTariffa dettaglio, PrintWriter writer) {
        this.manager.printFascia(dettaglio, writer);
    }
}

