/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.CalendarioFasceOrario;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.MisuraException;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.CalendarioCommercialeHelper;
import biz.elabor.prebilling.model.calendar.OffertaCommerciale;
import biz.elabor.prebilling.model.misure.BasicMisuraFasce;
import biz.elabor.prebilling.model.misure.Lettura;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraFasce;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import biz.elabor.prebilling.model.misure.TipoLettura;
import biz.elabor.prebilling.model.pra.PraGiornaliero;
import biz.elabor.prebilling.model.pra.PraMap;
import biz.elabor.prebilling.model.pra.PraMensile;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.ConsumiHelper;
import biz.elabor.prebilling.services.tariffe.CalendarException;
import biz.elabor.prebilling.services.tariffe.ConsumiException;
import biz.elabor.prebilling.services.tariffe.LetturaSegnanti;
import biz.elabor.prebilling.services.tariffe.MisuraContrattuale;
import biz.elabor.prebilling.services.tariffe.MontaggioCondition;
import biz.elabor.prebilling.services.tariffe.SmisCondition;
import biz.elabor.prebilling.services.tariffe.SmisException;
import biz.elabor.prebilling.services.tariffe.model.BasicRilevazioneTariffa;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterable;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.TappoIterator;
import org.homelinux.elabor.tools.StringUtils;

public class TariffeHelper {
    private static String getPivaDistributore(List<? extends LetturaSegnanti> rilevazioni) {
        String pivaDistr = null;
        for (LetturaSegnanti letturaSegnanti : rilevazioni) {
            pivaDistr = letturaSegnanti.getPivaDistributore();
            if (pivaDistr != null) break;
        }
        return pivaDistr;
    }

    private static double updateKa(double ka, LetturaSegnanti rilevazione) {
        double newKa = ka;
        Number kaRilevazione = rilevazione.getKa();
        if (kaRilevazione != null) {
            newKa = kaRilevazione.doubleValue();
        }
        return newKa;
    }

    private static double getKa(List<? extends LetturaSegnanti> rilevazioni, Date date, String codicePod) throws ConsumiException {
        double ka = 1.0;
        Iterator<? extends LetturaSegnanti> iterator = rilevazioni.iterator();
        Date dataMisura = null;
        if (iterator.hasNext()) {
            LetturaSegnanti rilevazione = iterator.next();
            ka = TariffeHelper.updateKa(ka, rilevazione);
            while (!date.before(dataMisura = rilevazione.getDataMisura())) {
                ka = TariffeHelper.updateKa(ka, rilevazione);
                if (!iterator.hasNext()) break;
                rilevazione = iterator.next();
            }
        }
        if (Math.abs(ka) < 1.0E-8) {
            throw new ConsumiException(ErroriElaborazione.K_ZERO, dataMisura, dataMisura, codicePod);
        }
        return ka;
    }

    public static Number getKa(List<? extends LetturaSegnanti> rilevazioni) {
        Number ka = 1.0;
        for (LetturaSegnanti letturaSegnanti : rilevazioni) {
            Number kaRilevazione = letturaSegnanti.getKa();
            if (kaRilevazione == null) continue;
            ka = kaRilevazione;
            break;
        }
        return ka;
    }

    private static LetturaSegnanti getPrimaMisura(MisuraContrattuale contratto, List<? extends LetturaSegnanti> rilevazioni, Date inizioConsumi, Number ka, String pivaDistr) {
        Date dataPrimaMisura;
        LetturaSegnanti primaMisura;
        LetturaSegnanti letturaContratto = TariffeHelper.getRilevazioneFromContratto(contratto, ka, pivaDistr);
        Date dataLetturaContratto = letturaContratto.getDataMisura();
        if (dataLetturaContratto.before(inizioConsumi)) {
            primaMisura = letturaContratto;
            dataPrimaMisura = dataLetturaContratto;
        } else {
            primaMisura = null;
            dataPrimaMisura = null;
        }
        for (LetturaSegnanti letturaSegnanti : rilevazioni) {
            Date currentDate = letturaSegnanti.getDataMisura();
            if (!currentDate.before(inizioConsumi)) break;
            if (dataPrimaMisura != null && !currentDate.after(dataPrimaMisura) || letturaSegnanti.isStimata()) continue;
            primaMisura = letturaSegnanti;
            dataPrimaMisura = currentDate;
        }
        return primaMisura;
    }

    private static ContrattoEle getContrattoRiferimento(Date dataFine, List<ContrattoEle> contrattiBatch, String codicePod) {
        ContrattoEle contratto = null;
        Iterator<ContrattoEle> iterator = contrattiBatch.iterator();
        boolean nonTrovato = true;
        ContrattoEle prevContratto = null;
        while (nonTrovato && iterator.hasNext()) {
            ContrattoEle actual = iterator.next();
            String codicePodActual = actual.getCodice();
            if (!codicePod.equals(codicePodActual)) continue;
            Date dataUltimaLettura = actual.getDataUltimaLettura();
            if (!dataUltimaLettura.before(dataFine)) {
                nonTrovato = false;
                contratto = dataUltimaLettura.equals(dataFine) ? actual : prevContratto;
            }
            prevContratto = actual;
        }
        return contratto;
    }

    private static LetturaSegnanti getMisuraFinale(Date fineConsumi, List<? extends LetturaSegnanti> rilevazioni) {
        LetturaSegnanti misuraFinale = null;
        Iterator<? extends LetturaSegnanti> iterator = rilevazioni.iterator();
        while (iterator.hasNext()) {
            LetturaSegnanti current;
            misuraFinale = current = iterator.next();
            Date currentDate = current.getDataMisura();
            if (current.isSmisMontaggio()) {
                currentDate = CalendarTools.previousDay(currentDate);
            }
            if (!currentDate.before(fineConsumi)) break;
        }
        return misuraFinale;
    }

    private static List<Double> getConsumi(MisuraContrattuale contratto, Date inizioConsumi, Date fineConsumi, LetturaSegnanti primaMisura, List<? extends LetturaSegnanti> rilevazioni, List<ContrattoEle> contrattiBatch, boolean complessivo, boolean azzeramento, ServiceStatus status) throws DataNotFoundException, CalendarNotFoundException, ConsumiException, CalendarException, SmisException, MisuraException {
        List<Double> consumi;
        if (rilevazioni == null || rilevazioni.isEmpty()) {
            consumi = new ArrayList<Double>();
        } else {
            String pivaDistr;
            Number ka;
            LetturaSegnanti misuraRiferimento;
            Date dataRiferimento;
            String codicePod;
            ContrattoEle contrattoDiRiferimento;
            Date dataMisuraFinale;
            Date dataPrimaMisura = primaMisura.getDataMisura();
            LetturaSegnanti misuraFinale = TariffeHelper.getMisuraFinale(fineConsumi, rilevazioni);
            Date date = dataMisuraFinale = misuraFinale == null ? new Date(0L) : misuraFinale.getDataMisura();
            if (fineConsumi.before(dataMisuraFinale) && (contrattoDiRiferimento = TariffeHelper.getContrattoRiferimento(fineConsumi, contrattiBatch, codicePod = contratto.getCodice())) != null && !(dataRiferimento = (misuraRiferimento = TariffeHelper.getRilevazioneFromContratto(contrattoDiRiferimento, ka = TariffeHelper.getKa(rilevazioni), pivaDistr = TariffeHelper.getPivaDistributore(rilevazioni))).getDataMisura()).before(fineConsumi) && dataRiferimento.before(dataMisuraFinale)) {
                misuraFinale = misuraRiferimento;
                dataMisuraFinale = dataRiferimento;
            }
            if (dataMisuraFinale.before(dataPrimaMisura)) {
                consumi = new ArrayList();
            } else {
                String pivaDistr2 = primaMisura.getPivaDistributore();
                String comIst = contratto.getCdComIst();
                double[] profilo = TariffeHelper.getProfilo(pivaDistr2, dataPrimaMisura, dataMisuraFinale, comIst, status);
                String codiceOfferta = contratto.getCodiceOfferta();
                String codicePod2 = contratto.getCodice();
                FasciaOraria[] fasce = TariffeHelper.getFasce(codicePod2, codiceOfferta, dataPrimaMisura, dataMisuraFinale, status);
                int numCifre = contratto.getNuCifre();
                Date fineContratto = contratto.getDataFine();
                consumi = TariffeHelper.calcolaConsumi(primaMisura, rilevazioni, inizioConsumi, fineConsumi, profilo, fasce, numCifre, codicePod2, complessivo, misuraFinale, fineContratto, azzeramento);
            }
        }
        return consumi;
    }

    public static RilMese buildRilmeseFromLetture(MisuraContrattuale contratto, boolean forfait, Date inizioConsumi, Date fineConsumi, List<? extends LetturaSegnanti> rilevazioni, List<ContrattoEle> contrattiBatch, boolean complessivo, ServiceStatus status) throws ConsumiException, CalendarNotFoundException, DataNotFoundException, CalendarException, SmisException, InvalidCurvaRilevazioniException, MisuraException {
        String pivaDistr;
        int anno = CalendarTools.getAnno(inizioConsumi);
        Month mese = CalendarTools.getMese(inizioConsumi);
        if (rilevazioni == null || rilevazioni.isEmpty()) {
            throw new InvalidCurvaRilevazioniException(CalendarTools.getDate(anno, mese, 1));
        }
        String codicePod = contratto.getCodice();
        Number ka = TariffeHelper.getKa(rilevazioni);
        LetturaSegnanti primaMisura = TariffeHelper.getPrimaMisura(contratto, rilevazioni, inizioConsumi, ka, pivaDistr = TariffeHelper.getPivaDistributore(rilevazioni));
        if (primaMisura == null) {
            throw new ConsumiException(ErroriElaborazione.NO_RILEVAZIONI, inizioConsumi, fineConsumi, codicePod);
        }
        String matricola = primaMisura.getMatricolaAtt();
        RilMese rilMese = new RilMese(codicePod, anno, mese, matricola);
        List<Double> consumi = TariffeHelper.getConsumi(contratto, inizioConsumi, fineConsumi, primaMisura, rilevazioni, contrattiBatch, complessivo, forfait, status);
        Iterator<Double> consumiIterator = consumi.iterator();
        for (int day : new DaysOfMonthIterable(anno, mese)) {
            Date date = CalendarTools.getDate(anno, mese, day);
            double kaDouble = TariffeHelper.getKa(rilevazioni, date, codicePod);
            RilGiorno rilGiorno = new RilGiorno(date);
            int hour = 0;
            while (hour < CalendarTools.getHoursOfDay(date)) {
                RilQuartoType type;
                double attiva;
                if (date.before(inizioConsumi) || date.after(fineConsumi)) {
                    attiva = 0.0;
                    type = RilQuartoType.NON_CONTRATTUALIZZATO;
                } else if (consumiIterator.hasNext()) {
                    attiva = consumiIterator.next();
                    type = RilQuartoType.RICOSTRUITO;
                } else {
                    throw new InvalidCurvaRilevazioniException(date);
                }
                int index = hour * 4;
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, attiva / kaDouble, kaDouble, type));
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, 0.0, kaDouble, type));
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, 0.0, kaDouble, type));
                rilGiorno.add(ConsumiHelper.createRilQuarto(index++, 0.0, kaDouble, type));
                ++hour;
            }
            rilMese.add(rilGiorno);
        }
        return rilMese;
    }

    public static LetturaSegnanti getRilevazioneFromContratto(MisuraContrattuale contratto, Number ka, String pivaDistr) {
        double[] attiva = contratto.getAttiva();
        String matricola = contratto.getMatricola();
        Date data = contratto.getDataUltimaLettura();
        int nuCifre = contratto.getNuCifre();
        return new BasicRilevazioneTariffa(attiva, data, matricola, nuCifre, ka, pivaDistr);
    }

    public static List<Lettura> getRilevazioniDataSingola(List<Lettura> rilevazioni) {
        ArrayList<Lettura> rilevazioniDataSingola = new ArrayList<Lettura>();
        if (!rilevazioni.isEmpty()) {
            Iterator<Lettura> iterator = rilevazioni.iterator();
            Lettura rilevazione = iterator.next();
            while (iterator.hasNext()) {
                Lettura actual = iterator.next();
                Date dataMisura = rilevazione.getDataMisura();
                Date dataMisuraActual = actual.getDataMisura();
                TipoLettura tipoLettura = rilevazione.getTipoLettura();
                if (dataMisura.equals(dataMisuraActual) && tipoLettura != TipoLettura.MONTAGGIO) {
                    rilevazione = TariffeHelper.compare(rilevazione, actual);
                    continue;
                }
                rilevazioniDataSingola.add(rilevazione);
                rilevazione = actual;
            }
            rilevazioniDataSingola.add(rilevazione);
        }
        return rilevazioniDataSingola;
    }

    private static Lettura compare(Lettura rilevazione, Lettura actual) {
        TipoLettura tipoLetturaActual = actual.getTipoLettura();
        TipoLettura tipoLetturaRilevazione = rilevazione.getTipoLettura();
        return tipoLetturaRilevazione.compare(tipoLetturaActual) >= 0 ? rilevazione : actual;
    }

    public static Iterator<Mno> buildSmisIterator(List<Mno> mno) {
        SmisCondition smisCondition = new SmisCondition();
        return TariffeHelper.buildMnoIterator(mno, smisCondition);
    }

    public static Iterator<Mno> buildMontaggiIterator(List<Mno> mno) {
        MontaggioCondition smisCondition = new MontaggioCondition();
        return TariffeHelper.buildMnoIterator(mno, smisCondition);
    }

    private static Iterator<Mno> buildMnoIterator(List<Mno> mno, Condition<Mno> condition) {
        Filter<Mno> filter = new Filter<Mno>(condition);
        List<Object> filtered = mno == null ? new ArrayList() : filter.filter(mno);
        Iterator<Object> iterator = filtered.iterator();
        Mno tappo = TariffeHelper.buildMnoTappo();
        return new TappoIterator<Mno>(iterator, tappo);
    }

    public static Iterator<Mno> buildMnoIterator(Collection<Mno> mno) {
        Mno tappo = TariffeHelper.buildMnoTappo();
        Iterator<Mno> iterator = mno.iterator();
        return new TappoIterator<Mno>(iterator, tappo);
    }

    public static Iterator<LetturaSegnanti> buildLettureIterator(Collection<LetturaSegnanti> mno) {
        Mno tappo = TariffeHelper.buildMnoTappo();
        Iterator<LetturaSegnanti> iterator = mno.iterator();
        return new TappoIterator<LetturaSegnanti>(iterator, tappo);
    }

    public static Mno buildMnoTappo() {
        Date endOfTime = CalendarTools.getEndOfTime();
        Misura misura = new Misura(endOfTime, false, 0, null);
        return new Mno(null, null, null, misura, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, false, null);
    }

    public static <R extends LetturaSegnanti> List<Double> calcolaConsumi(LetturaSegnanti primaMisura, List<R> rilevazioni, Date inizioConsumi, Date fineConsumi, double[] profilo, FasciaOraria[] fasce, int numCifre, String codicePod, boolean monorario, LetturaSegnanti letturaDiTaglio, Date fineContratto, boolean azzeramento) throws ConsumiException, CalendarException, SmisException, MisuraException {
        TariffeHelper.checkInput(inizioConsumi, fineConsumi, primaMisura, rilevazioni, profilo, fasce, codicePod, letturaDiTaglio);
        ArrayList<Double> consumi = new ArrayList<Double>();
        LetturaSegnanti letturaPrecedente = primaMisura;
        int offsetProfilo = 0;
        double[] attivaPrev = letturaPrecedente.getAttiva();
        double[] consumoFasce = new double[FasciaOraria.values().length];
        Date dataPrimaLettura = letturaPrecedente.getDataMisura();
        for (LetturaSegnanti rilevazione : rilevazioni) {
            Date dataLetturaPrecedente;
            Date dataLettura = rilevazione.getDataMisura();
            if (dataLettura.after(dataLetturaPrecedente = letturaPrecedente.getDataMisura()) || letturaPrecedente.isSmisMontaggio()) {
                if (letturaDiTaglio != null && fineContratto != null && fineContratto.before(dataLettura)) {
                    rilevazione = letturaDiTaglio;
                }
                if (rilevazione.isSmisMontaggio()) {
                    if (!TariffeHelper.checkMontaggio(dataLettura, dataLetturaPrecedente, inizioConsumi)) {
                        throw new SmisException(codicePod, dataLettura);
                    }
                } else if (dataLettura.before(inizioConsumi)) {
                    offsetProfilo += TariffeHelper.calcolaOffsetProfilo(dataLettura, dataLetturaPrecedente);
                    dataPrimaLettura = dataLettura;
                    consumoFasce = new double[FasciaOraria.values().length];
                } else if (TariffeHelper.sameMatricola(rilevazione, letturaPrecedente)) {
                    double[] attiva = rilevazione.getAttiva();
                    String flusso = rilevazione.getCodiceFlusso();
                    Number kaObject = rilevazione.getKa();
                    if (kaObject == null) {
                        kaObject = letturaPrecedente.getKa();
                    }
                    double kA = kaObject.doubleValue();
                    TariffeHelper.addConsumoComplessivo(consumoFasce, attivaPrev, attiva, kA, numCifre, codicePod, dataLettura, flusso, azzeramento);
                    if (!monorario || !dataLettura.before(fineConsumi)) {
                        int hours = TariffeHelper.getOre(dataPrimaLettura, dataLettura);
                        double[] profiloPeriodo = Arrays.copyOfRange(profilo, offsetProfilo, offsetProfilo + hours);
                        FasciaOraria[] fascePeriodo = Arrays.copyOfRange(fasce, offsetProfilo, offsetProfilo + hours);
                        List<Double> consumiPeriodo = TariffeHelper.calcolaConsumi(consumoFasce, dataPrimaLettura, dataLettura, inizioConsumi, fineConsumi, profiloPeriodo, fascePeriodo, monorario);
                        consumi.addAll(consumiPeriodo);
                        offsetProfilo += TariffeHelper.calcolaOffsetProfilo(dataLettura, dataPrimaLettura);
                        dataPrimaLettura = dataLettura;
                        consumoFasce = new double[FasciaOraria.values().length];
                    }
                } else if (!dataLettura.equals(dataLetturaPrecedente)) {
                    String matricolaPrevRil = letturaPrecedente.getMatricolaAtt();
                    String matricola = rilevazione.getMatricolaAtt();
                    throw new ConsumiException(ErroriElaborazione.INCONSISTENT_CAMBIO_CONTATORE, matricolaPrevRil, matricola, dataLettura, dataLetturaPrecedente, codicePod);
                }
                letturaPrecedente = rilevazione;
                attivaPrev = letturaPrecedente.getAttiva();
                if (dataLettura.before(fineConsumi) || letturaPrecedente.isSmisMontaggio()) continue;
                break;
            }
            if (!dataLettura.equals(dataLetturaPrecedente)) continue;
            letturaPrecedente = rilevazione;
            attivaPrev = letturaPrecedente.getAttiva();
        }
        return consumi;
    }

    private static boolean checkMontaggio(Date dataLettura, Date dataLetturaPrecedente, Date inizioConsumi) {
        return TariffeHelper.matchPrevDate(dataLettura, dataLetturaPrecedente) || dataLettura.before(inizioConsumi);
    }

    private static boolean matchPrevDate(Date dataLettura, Date dataLetturaPrecedente) {
        return CalendarTools.nextDay(dataLetturaPrecedente).equals(dataLettura);
    }

    private static boolean sameMatricola(LetturaSegnanti rilevazione, LetturaSegnanti prevRilevazione) {
        String matricola = rilevazione.getMatricolaAtt();
        String prevMatricola = prevRilevazione.getMatricolaAtt();
        return StringUtils.isEmpty(matricola) || StringUtils.isEmpty(prevMatricola) || matricola.equals(prevMatricola);
    }

    private static int calcolaOffsetProfilo(Date dataRilevazione, Date dataPrevRilevazione) {
        return dataPrevRilevazione == null ? 0 : TariffeHelper.getOre(dataPrevRilevazione, dataRilevazione);
    }

    public static List<Double> calcolaConsumi(double[] consumoFasce, Date dataMisuraIniziale, Date dataMisuraFinale, Date inizioConsumi, Date fineConsumi, double[] profilo, FasciaOraria[] fasce, boolean monorario) throws CalendarException {
        List<Double> consumi;
        if (monorario) {
            double consumoMonorario = 0.0;
            double[] dArray = consumoFasce;
            int n2 = consumoFasce.length;
            int n3 = 0;
            while (n3 < n2) {
                double consumoFascia = dArray[n3];
                consumoMonorario += consumoFascia;
                ++n3;
            }
            consumi = TariffeHelper.getConsumiOrari(consumoMonorario, profilo);
        } else {
            consumi = TariffeHelper.getConsumiOrari(dataMisuraIniziale, dataMisuraFinale, consumoFasce, profilo, fasce);
        }
        Date previousDayInizio = CalendarTools.previousDay(inizioConsumi);
        int offsetConsumiBefore = dataMisuraIniziale.before(previousDayInizio) ? TariffeHelper.getOre(dataMisuraIniziale, previousDayInizio) : 0;
        int offsetConsumiPost = dataMisuraFinale.after(fineConsumi) ? TariffeHelper.getOre(fineConsumi, dataMisuraFinale) : 0;
        int consumiSize = consumi.size();
        return consumi.subList(offsetConsumiBefore, consumiSize - offsetConsumiPost);
    }

    public static double[] getConsumoFasce(double[] misuraIniziale, double[] misuraFinale, int numCifre, String codicePod, Date data, String flusso, boolean azzeramento) throws MisuraException {
        double[] consumoFasce = new double[FasciaOraria.values().length];
        TariffeHelper.addConsumoComplessivo(consumoFasce, misuraIniziale, misuraFinale, 1.0, numCifre, codicePod, data, flusso, azzeramento);
        return consumoFasce;
    }

    private static void addConsumoComplessivo(double[] consumo, double[] misuraIniziale, double[] misuraFinale, double kA, int numCifre, String codicePod, Date data, String flusso, boolean azzeramento) throws MisuraException {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double giroContatore;
            double consumoFascia;
            FasciaOraria fascia = fasciaOrariaArray[n3];
            int ordinal = fascia.ordinal();
            double d2 = consumoFascia = azzeramento ? misuraFinale[ordinal] : misuraFinale[ordinal] - misuraIniziale[ordinal];
            if (consumoFascia < 0.0 && (consumoFascia += (giroContatore = Math.pow(10.0, numCifre))) > giroContatore / 2.0) {
                throw new MisuraException(ErroriElaborazione.GIRO_CONTATORE_SPURIO, codicePod, data, flusso);
            }
            int n4 = ordinal;
            consumo[n4] = consumo[n4] + consumoFascia * kA;
            ++n3;
        }
    }

    private static <R extends LetturaSegnanti> void checkInput(Date inizioConsumi, Date fineConsumi, LetturaSegnanti primaMisura, List<R> rilevazioni, double[] profilo, FasciaOraria[] fasce, String codicePod, LetturaSegnanti rilevazioneDaContratto) throws ConsumiException {
        Date dataUltimaRilevazione;
        if (rilevazioni.isEmpty()) {
            throw new ConsumiException(ErroriElaborazione.NO_RILEVAZIONI, inizioConsumi, fineConsumi, codicePod);
        }
        int numeroRilevazioni = rilevazioni.size();
        LetturaSegnanti ultimaRilevazione = (LetturaSegnanti)rilevazioni.get(numeroRilevazioni - 1);
        Date dataPrimaRilevazione = primaMisura.getDataMisura();
        Date date = dataUltimaRilevazione = rilevazioneDaContratto == null ? ultimaRilevazione.getDataMisura() : rilevazioneDaContratto.getDataMisura();
        if (!dataPrimaRilevazione.before(inizioConsumi) || dataUltimaRilevazione.before(fineConsumi)) {
            ErroriElaborazione errore = ErroriElaborazione.NO_RILEVAZIONI_PERIODO;
            throw new ConsumiException(errore, inizioConsumi, fineConsumi, dataPrimaRilevazione, dataUltimaRilevazione, codicePod);
        }
        int ore = TariffeHelper.getOre(dataPrimaRilevazione, dataUltimaRilevazione);
        if (ore != profilo.length) {
            throw new ConsumiException(ErroriElaborazione.PROFILO_NON_COERENTE);
        }
        if (ore != fasce.length) {
            throw new ConsumiException(ErroriElaborazione.FASCE_NON_COERENTI);
        }
    }

    public static int getOre(Date startDate, Date endDate) {
        Date nextDaystartDate = CalendarTools.nextDay(startDate);
        Date nextDayEndDate = CalendarTools.nextDay(endDate);
        return CalendarTools.getHours(nextDaystartDate, nextDayEndDate);
    }

    public static List<Double> getConsumiOrari(Date startDate, Date endDate, double[] consumoFasce, double[] profilo, FasciaOraria[] fasce) throws CalendarException {
        MisuraFasce sommaProfili = TariffeHelper.getSommaProfili(profilo, fasce);
        return TariffeHelper.buildConsumiOrari(startDate, endDate, consumoFasce, profilo, fasce, sommaProfili);
    }

    public static List<Double> getConsumiOrari(double consumoComplessivo, double[] profilo) {
        double sommaProfili = TariffeHelper.getSommaProfili(profilo);
        return TariffeHelper.buildConsumiOrari(consumoComplessivo, profilo, sommaProfili);
    }

    private static double getSommaProfili(double[] profilo) {
        double peso = 0.0;
        int index = 0;
        while (index < profilo.length) {
            peso += profilo[index];
            ++index;
        }
        return peso;
    }

    private static List<Double> buildConsumiOrari(double consumoComplessivo, double[] profilo, double pesoComplessivo) {
        LinkedList<Double> consumi = new LinkedList<Double>();
        double ore = profilo.length;
        int index = 0;
        while (index < profilo.length) {
            double peso = profilo[index];
            double consumo = pesoComplessivo == 0.0 ? consumoComplessivo / ore : consumoComplessivo / pesoComplessivo * peso;
            consumi.add(consumo);
            ++index;
        }
        return consumi;
    }

    private static List<Double> buildConsumiOrari(Date startDate, Date endDate, double[] consumoFasce, double[] profilo, FasciaOraria[] fasce, MisuraFasce pesi) throws CalendarException {
        LinkedList<Double> consumi = new LinkedList<Double>();
        double[] ore = TariffeHelper.oreFascia(fasce);
        double totale = 0.0;
        int index = 0;
        while (index < profilo.length) {
            double peso = profilo[index];
            FasciaOraria fascia = fasce[index];
            double pesoFascia = pesi.getValue(fascia);
            double consumoFascia = consumoFasce[fascia.ordinal()];
            double consumo = pesoFascia == 0.0 ? consumoFascia / ore[fascia.ordinal()] : consumoFascia / pesoFascia * peso;
            consumi.add(consumo);
            totale += consumo;
            ++index;
        }
        double[] dArray = consumoFasce;
        int n2 = consumoFasce.length;
        int n3 = 0;
        while (n3 < n2) {
            double consumoFascia = dArray[n3];
            totale -= consumoFascia;
            ++n3;
        }
        if (Math.abs(totale) > 1.0E-8) {
            throw new CalendarException(startDate, endDate);
        }
        return consumi;
    }

    private static double[] oreFascia(FasciaOraria[] fasce) {
        double[] ore = new double[FasciaOraria.values().length];
        FasciaOraria[] fasciaOrariaArray = fasce;
        int n2 = fasce.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            int n4 = fascia.ordinal();
            ore[n4] = ore[n4] + 1.0;
            ++n3;
        }
        return ore;
    }

    private static MisuraFasce getSommaProfili(double[] profilo, FasciaOraria[] fasce) {
        double[] pesi = new double[FasciaOraria.values().length];
        int index = 0;
        while (index < profilo.length) {
            double peso = profilo[index];
            FasciaOraria fascia = fasce[index];
            int n2 = fascia.ordinal();
            pesi[n2] = pesi[n2] + peso;
            ++index;
        }
        return new BasicMisuraFasce(null, pesi);
    }

    public static double[] getProfilo(String pivaDistributore, Date dataFirst, Date dataLast, String cdComIst, ServiceStatus status) throws DataNotFoundException {
        int size = TariffeHelper.getOre(dataFirst, dataLast);
        double[] profilo = new double[size];
        int idZona = status.getIdZona(cdComIst);
        PraMap praMap = status.getPraMap();
        Date startDate = CalendarTools.nextDay(dataFirst);
        ElaborCalendar calendar = new ElaborCalendar(startDate);
        calendar.setGiorno(1);
        int indexProfilo = 0;
        while (!calendar.getDate().after(dataLast)) {
            int currAnno = calendar.getAnno();
            Month currMese = calendar.getMese();
            PraMensile praMese = praMap.get(pivaDistributore, idZona, currAnno, currMese);
            for (PraGiornaliero praGiorno : praMese.getPra()) {
                Date date = praGiorno.getDate();
                if (!date.after(dataFirst) || date.after(dataLast)) continue;
                double[] dArray = praGiorno.getValues();
                int n2 = dArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    double pra;
                    profilo[indexProfilo] = pra = dArray[n3];
                    ++indexProfilo;
                    ++n3;
                }
            }
            calendar.addMesi(1);
        }
        return profilo;
    }

    public static FasciaOraria[] getFasce(String codicePod, String codiceOfferta, Date dataFirst, Date dataLast, ServiceStatus status) throws CalendarNotFoundException {
        int size = TariffeHelper.getOre(dataFirst, dataLast);
        FasciaOraria[] fasce = new FasciaOraria[size];
        CalendarMap calendarMap = status.getCalendarMap();
        String idCalendario = TariffeHelper.getCalendarId(codiceOfferta, status);
        Date startDate = CalendarTools.nextDay(dataFirst);
        ElaborCalendar calendar = new ElaborCalendar(startDate);
        calendar.setGiorno(1);
        int indexFasce = 0;
        while (!calendar.getDate().after(dataLast)) {
            int currAnno = calendar.getAnno();
            Month currMese = calendar.getMese();
            CalendarioFasceMensile calMese = CalendarioCommercialeHelper.getCalendario(idCalendario, currAnno, currMese, codicePod, calendarMap);
            for (CalendarioFasceGiornaliero calGiorno : calMese) {
                Date date = calGiorno.getDate();
                if (!date.after(dataFirst) || date.after(dataLast)) continue;
                int hoursOfDay = CalendarTools.getHoursOfDay(date);
                int index = 0;
                while (index < hoursOfDay) {
                    int fixedIndex = TariffeHelper.fixIndex(index, hoursOfDay);
                    CalendarioFasceOrario calOra = (CalendarioFasceOrario)calGiorno.get(fixedIndex);
                    fasce[indexFasce] = calOra.getFascia();
                    ++indexFasce;
                    ++index;
                }
            }
            calendar.addMesi(1);
        }
        return fasce;
    }

    public static String getCalendarId(String codiceOfferta, ServiceStatus status) {
        OffertaCommerciale offerta = status.getOffertaCommerciale(codiceOfferta);
        return offerta.getCalendarId();
    }

    private static int fixIndex(int index, int hoursOfDay) {
        int fixedIndex = hoursOfDay == 24 ? index : (hoursOfDay == 23 ? (index <= 3 ? index : index + 1) : (index <= 3 ? index : index - 1));
        return fixedIndex;
    }

    public static String getTipoLettura(boolean stimata, String codiceFlusso, String tipoRaccolta, String matricolaAtt, boolean calcolata) {
        String raccolta;
        String flusso = codiceFlusso.toUpperCase();
        String string = raccolta = tipoRaccolta == null ? "" : tipoRaccolta.toUpperCase();
        String tipo = flusso.startsWith("R") || flusso.startsWith("DSR") || StrategyHelper.MOROSITA.contains(flusso.toUpperCase()) ? "R" : (flusso.startsWith("SMIS") && raccolta.equals("M") ? "M" : (flusso.startsWith("SMIS") && raccolta.equals("S") ? "G" : (stimata ? "S" : (flusso.startsWith("INT") || calcolata ? "C" : (flusso.startsWith("VP") ? "E" : (flusso.startsWith("GIADA") || flusso.startsWith("SNM") || flusso.startsWith("V") && matricolaAtt.startsWith("SNM_") ? "A" : (flusso.startsWith("V") ? "V" : "E")))))));
        return tipo;
    }
}

