/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.MisuraFasceQuantita;
import biz.elabor.prebilling.model.tariffe.TariffaApplicazione;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TariffaMultiApplicazione {
    private final Contratto contratto;
    private final List<TariffaApplicazione> subTariffe;
    private final Date startDate;
    private final double coeffPerdite;
    private final boolean perdite;
    private final boolean scivolo;
    private final boolean rettifica;
    private TariffaMultiApplicazione penale;
    private double qtMisura;

    public TariffaMultiApplicazione(Contratto contratto, Date startDate, boolean perdite, double coeffPerdite, boolean scivolo, boolean rettifica, TariffaApplicazione tariffaSingola) {
        this(contratto, startDate, perdite, coeffPerdite, scivolo, rettifica, TariffaMultiApplicazione.initSubApplicazioni(tariffaSingola));
    }

    private static List<TariffaApplicazione> initSubApplicazioni(TariffaApplicazione tariffaSingola) {
        return Arrays.asList(tariffaSingola);
    }

    public TariffaMultiApplicazione(Contratto contratto, Date startDate, boolean perdite, double coeffPerdite, boolean scivolo, boolean rettifica, List<TariffaApplicazione> subTariffe) {
        this.contratto = contratto;
        this.subTariffe = subTariffe;
        this.startDate = startDate;
        this.perdite = perdite;
        this.coeffPerdite = coeffPerdite;
        this.scivolo = scivolo;
        this.rettifica = rettifica;
        this.penale = null;
        this.qtMisura = scivolo ? 0.0 : this.subTariffe.get(0).getQtMisura();
    }

    public List<TariffaApplicazione> getSubTariffe() {
        return this.subTariffe;
    }

    public Contratto getContratto() {
        return this.contratto;
    }

    public String getCodIndiceApplicato() {
        return this.subTariffe.get(0).getCodIndiceApplicato();
    }

    public double getQtMisura() {
        return this.qtMisura;
    }

    public double getQtMisuraCompl() {
        return this.subTariffe.get(0).getQtMisura();
    }

    public double getQtMisuraEffettiva() {
        return this.subTariffe.get(0).getQtMisuraEffettiva();
    }

    public double getQtMisuraEffettiva(FasciaOraria fascia) {
        return this.subTariffe.get(0).getQtMisuraEffettiva(fascia);
    }

    public double getQtMisura(FasciaOraria fascia) {
        return this.subTariffe.get(0).getQtMisura(fascia);
    }

    public boolean isScivolo() {
        return this.scivolo;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public boolean isRettifica() {
        return this.rettifica;
    }

    public double getPrezzoMedioPonderatoNetto(FasciaOraria fascia) {
        double value = 0.0;
        for (TariffaApplicazione subTariffa : this.subTariffe) {
            MisuraFasceQuantita tariffa = subTariffa.getTariffa();
            value += tariffa.getPrezzoMedioPonderatoNetto(fascia);
        }
        return value;
    }

    public double getCoeffPerdite() {
        return this.coeffPerdite;
    }

    public double getPrezzoMedioPonderatoPerdite(FasciaOraria fascia) {
        return this.getPrezzoMedioPonderatoNetto(fascia) * (1.0 + this.coeffPerdite / 100.0);
    }

    public double getSommaImportiOrari(FasciaOraria fascia) {
        double value = 0.0;
        for (TariffaApplicazione tariffaApp : this.subTariffe) {
            MisuraFasceQuantita tariffa = tariffaApp.getTariffa();
            value += tariffa.getTotale(fascia);
        }
        return value;
    }

    public double getPrezzoMedioPonderato(FasciaOraria fascia) {
        return this.perdite ? this.getPrezzoMedioPonderatoPerdite(fascia) : this.getPrezzoMedioPonderatoNetto(fascia);
    }

    public List<DettaglioTariffa> getFirstDettagli() {
        return this.subTariffe.get(0).getDettagli();
    }

    public int getTipoApplicazione() {
        return this.contratto.getTipoApplicazione();
    }

    public void setPenale(TariffaMultiApplicazione penale) {
        this.penale = penale;
    }

    public TariffaMultiApplicazione getPenale() {
        return this.penale;
    }

    public void setQtMisura(double qtMisura) {
        this.qtMisura = qtMisura;
    }
}

