/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.MisuraFasceQuantita;
import biz.elabor.prebilling.model.tariffe.TariffaApplicazione;
import biz.elabor.prebilling.services.common.TariffeAccumulator;
import biz.elabor.prebilling.services.common.TariffeMonorarieAccumulator;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TipoCalcoloManager;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;

class MonorarioManager
implements TipoCalcoloManager {
    MonorarioManager() {
    }

    @Override
    public TariffeAccumulator getAccumulator(RilMese rilMese, CalendarioFasceMensile calendarioFasce, double coeffUM, Date startDate, double qtconfla, double KAttiva, double[] prezziDefault, boolean perdite, double coeffPerdite, double emtaruni, double emspread, double emspreneg, List<Mno> mnoList) {
        return new TariffeMonorarieAccumulator(rilMese, coeffUM, startDate, qtconfla, KAttiva, prezziDefault, perdite, coeffPerdite, emtaruni, emspread, emspreneg, mnoList);
    }

    @Override
    public void printSommaImportiOrari(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        double totale = tariffa.isScivolo() ? 0.0 : tariffa.getSommaImportiOrari(FasciaOraria.F1);
        writer.println(String.valueOf(label) + ";" + format.format(totale));
    }

    @Override
    public void printSommaImportiOrari(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        MisuraFasceQuantita misura = tariffa.getTariffa();
        double totale = misura.getTotale(FasciaOraria.F1);
        writer.println(String.valueOf(label) + ";" + format.format(totale));
    }

    @Override
    public void printSommaConsumi(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        double qtMisura = tariffa.isScivolo() ? 0.0 : tariffa.getQtMisura();
        writer.println(String.valueOf(label) + ";" + format.format(qtMisura));
    }

    @Override
    public void printSommaConsumiEffettivi(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        double qtMisura = tariffa.isScivolo() ? 0.0 : tariffa.getQtMisuraEffettiva();
        writer.println(String.valueOf(label) + ";" + format.format(qtMisura));
    }

    @Override
    public void printSommaConsumiCompl(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        double qtMisura = tariffa.isScivolo() ? 0.0 : tariffa.getQtMisuraCompl();
        writer.println(String.valueOf(label) + ";" + format.format(qtMisura));
    }

    @Override
    public void printSommaConsumi(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        double qtMisura = tariffa.getQtMisuraEffettiva();
        writer.println(String.valueOf(label) + ";" + format.format(qtMisura));
    }

    @Override
    public void printPrezzoMedioPonderatoNetto(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        double prezzo = tariffa.isScivolo() ? 0.0 : tariffa.getPrezzoMedioPonderatoNetto(FasciaOraria.F1);
        writer.println(String.valueOf(label) + ";" + format.format(prezzo));
    }

    @Override
    public void printPrezzoMedioPonderatoNetto(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        MisuraFasceQuantita misura = tariffa.getTariffa();
        double prezzo = misura.getPrezzoMedioPonderatoNetto(FasciaOraria.F1);
        writer.println(String.valueOf(label) + ";" + format.format(prezzo));
    }

    @Override
    public void printPrezzoMedioPonderatoPerdite(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        double prezzo = tariffa.getPrezzoMedioPonderatoPerdite(FasciaOraria.F1);
        writer.println(String.valueOf(label) + ";" + format.format(prezzo));
    }

    @Override
    public void printFascia(DettaglioTariffa dettaglio, PrintWriter writer) {
    }
}

