/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.MisureHandler;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;

class MnoHandler
implements MisureHandler<Mno> {
    private final ServiceStatus status;
    private final PrebillingError errore;
    private final String messaggio;
    private final Destinatari destinatari;
    private final StatoMisure stato;
    private final Date dataStart;
    private final Date dataStop;

    public MnoHandler(ServiceStatus status, Destinatari destinatari, StatoMisure stato, PrebillingError errore, String messaggio, int anno, Month mese) {
        this.status = status;
        this.destinatari = destinatari;
        this.stato = stato;
        this.errore = errore;
        this.messaggio = messaggio;
        this.dataStart = CalendarTools.getDate(anno, mese, 1);
        this.dataStop = CalendarTools.getNextMese(this.dataStart);
    }

    @Override
    public void handleMisura(Mno misura, String azienda) {
        Date dataMisura = misura.getDataMisura();
        if (!dataMisura.before(this.dataStart) && dataMisura.before(this.dataStop)) {
            MnoResult result = new MnoResult(misura, this.errore, this.messaggio);
            this.status.addTariffeNonorarieResult(this.destinatari, this.stato, result);
        }
    }
}

