/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.tariffe.AliquotaPerdite;
import biz.elabor.prebilling.services.tariffe.Livello;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.safe.BasicSafeMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class GetAliquotePerditeStrategy
implements ServiceStrategy {
    private final MisureDao misureDao;

    public GetAliquotePerditeStrategy(MisureDao misureDao) {
        this.misureDao = misureDao;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ErrorWrapper error = new ErrorWrapper(ErroriElaborazione.LIVELLO_NOTFOUD);
        BasicSafeMap<Integer, Map<Date, Double>> coeffPerdite = new BasicSafeMap<Integer, Map<Date, Double>>(error);
        List<AliquotaPerdite> aliquote = this.misureDao.getAliquotePerdite();
        for (AliquotaPerdite aliquota : aliquote) {
            Date data = aliquota.getData();
            Livello[] livelloArray = Livello.values();
            int n2 = livelloArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Livello livello = livelloArray[n3];
                Map<Date, Double> coeffPerditeLivello = GetAliquotePerditeStrategy.getCoeffPerdite(coeffPerdite, livello);
                double coeff = livello.getCoeffPerdite(aliquota);
                coeffPerditeLivello.put(data, coeff);
                ++n3;
            }
        }
        status.setCoeffPerdite(coeffPerdite);
        return true;
    }

    private static Map<Date, Double> getCoeffPerdite(SafeMap<Integer, Map<Date, Double>> coeffPerdite, Livello livello) {
        TreeMap<Date, Double> coeffPerditeLivello;
        Integer key = livello.ordinal();
        try {
            coeffPerditeLivello = (TreeMap<Date, Double>)coeffPerdite.get(key);
        }
        catch (DataNotFoundException exc) {
            coeffPerditeLivello = new TreeMap<Date, Double>();
            coeffPerdite.add(key, coeffPerditeLivello);
        }
        return coeffPerditeLivello;
    }
}

