/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.tariffe.AbstractExportTariffeStrategy;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TariffeMesePod;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportTariffeResellerStrategy
extends AbstractExportTariffeStrategy {
    public ExportTariffeResellerStrategy(int anno, Month mese, Date dataMax, TipoCalcolo tipo, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(anno, mese, dataMax, Destinatari.RESELLER, tipo, configuration, talkManager);
    }

    @Override
    protected void exportTariffe(ListMap<String, TariffaMultiApplicazione> mappaTariffe, String fileName, ServiceStatus status) throws IOException {
        String idEsecuzione = status.getIdEsecuzione();
        for (Map.Entry entryTariffeAzienda : mappaTariffe.entrySet()) {
            String azienda = (String)entryTariffeAzienda.getKey();
            List listaTariffeAzienda = (List)entryTariffeAzienda.getValue();
            LinkedHashMap<String, TariffeMesePod> mappaTariffeAzienda = new LinkedHashMap<String, TariffeMesePod>();
            this.fillTariffe(listaTariffeAzienda, mappaTariffeAzienda);
            this.checkDettagli(mappaTariffeAzienda, status);
            status.addTariffeElaborateReseller(mappaTariffeAzienda);
            this.printTariffe(azienda, mappaTariffeAzienda, fileName, status);
            if (!this.configuration.hasDettaglioReseller()) continue;
            File parent = ConfigurationHelper.getResellerTmpFolder(this.configuration, idEsecuzione, azienda, Funzionalita.TARIFFE, "");
            this.printDettagliTariffe(mappaTariffeAzienda, parent, true);
        }
    }

    @Override
    protected ListMap<String, TariffaMultiApplicazione> getTariffe(ServiceStatus status) {
        return status.getTariffeMedieMensiliReseller();
    }

    @Override
    protected File getFolder(String idEsecuzione, String azienda) {
        return ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, Funzionalita.TARIFFE);
    }
}

