/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.DatiMisura;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.ContrattiPodList;
import biz.elabor.prebilling.model.giada.MappaContratti;
import biz.elabor.prebilling.services.tariffe.AbstractExportRettificheTariffeStrategy;
import biz.elabor.prebilling.services.tariffe.ContrattiEleHelper;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.MissingIndiceException;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.setmap.SetMap;

public class ExportRettificheTariffeResellerStrategy
extends AbstractExportRettificheTariffeStrategy {
    public ExportRettificheTariffeResellerStrategy(int anno, Month mese, TipoCalcolo tipo, String onlyPod, String codiceReseller, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice, PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, IndiciDao indiciDao, TalkManager talkManager) {
        super(Destinatari.RESELLER, anno, mese, tipo, onlyPod, codiceReseller, scivoloEnabled, scivoloForced, onlyTipoTrattamento, bloccoIndice, configuration, giadaDao, misureDao, indiciDao, talkManager);
    }

    @Override
    protected SetMap<Date, DatiMisura> getMesiRettifiche(ServiceStatus status) {
        MappaContratti contratti;
        SetMap<Date, DatiMisura> mesiRettifiche = this.misureDao.getMesiRettifiche(this.annoRif, this.meseRif, this.onlyPod, Destinatari.RESELLER);
        Map<String, Multipunto> multiPodMap = this.misureDao.getMultiPodMap(this.annoRif, this.meseRif);
        try {
            contratti = this.getContratti(multiPodMap, status);
        }
        catch (MissingIndiceException exc) {
            contratti = new MappaContratti();
        }
        ExportRettificheTariffeResellerStrategy.ensureMissing(mesiRettifiche, contratti);
        this.ensureMeseRif(mesiRettifiche);
        return mesiRettifiche;
    }

    protected MappaContratti getContratti(Map<String, Multipunto> multiPodMap, ServiceStatus status) throws MissingIndiceException {
        return ContrattiEleHelper.getContratti(Destinatari.RESELLER, this.annoRif, this.meseRif, this.onlyPod, multiPodMap, this.codiceReseller, this.giadaDao, status);
    }

    private static void ensureMissing(SetMap<Date, DatiMisura> mesiRettifiche, MappaContratti contratti) {
        HashMap<String, Date> podMap = new HashMap<String, Date>();
        for (ContrattiPodList list : contratti) {
            for (Map.Entry entry : list.entrySet()) {
                ContrattoEle contratto;
                Date dataUltimaLettura;
                String codicePod = (String)entry.getKey();
                List contrattiPod = (List)entry.getValue();
                if (!contrattiPod.isEmpty() && (dataUltimaLettura = (contratto = (ContrattoEle)contrattiPod.get(0)).getDataUltimaLettura()) != null) {
                    podMap.put(codicePod, dataUltimaLettura);
                }
                if (podMap.size() <= 500) continue;
                ExportRettificheTariffeResellerStrategy.ensureMissing(mesiRettifiche, podMap);
                podMap.clear();
            }
        }
        ExportRettificheTariffeResellerStrategy.ensureMissing(mesiRettifiche, podMap);
    }

    private static void ensureMissing(SetMap<Date, DatiMisura> mesiRettifiche, Map<String, Date> podMap) {
        if (!podMap.isEmpty()) {
            for (Map.Entry<String, Date> podEntry : podMap.entrySet()) {
                String codicePod = podEntry.getKey();
                Date firstMonth = ExportRettificheTariffeResellerStrategy.findFirst(mesiRettifiche, codicePod);
                if (firstMonth == null) continue;
                Date dataLastMisura = podEntry.getValue();
                Date dataInizio = CalendarTools.nextDay(dataLastMisura);
                Date mese = CalendarTools.getStartOfMonth(dataInizio);
                while (mese.before(firstMonth)) {
                    DatiMisura meseRettifica = new DatiMisura(mese, codicePod);
                    mesiRettifiche.add(mese, meseRettifica);
                    mese = CalendarTools.getNextMese(mese);
                }
            }
        }
    }

    private static Date findFirst(SetMap<Date, DatiMisura> mesiRettifiche, String codicePod) {
        Date first = null;
        for (Map.Entry<Date, Set<DatiMisura>> entry : mesiRettifiche.entrySet()) {
            if (!ExportRettificheTariffeResellerStrategy.findPod(codicePod, entry)) continue;
            first = entry.getKey();
        }
        return first;
    }

    private static boolean findPod(String codicePod, Map.Entry<Date, Set<DatiMisura>> entry) {
        boolean exists = false;
        for (DatiMisura datiMisura : entry.getValue()) {
            if (!codicePod.equals(datiMisura.getCodicePod())) continue;
            exists = true;
            break;
        }
        return exists;
    }
}

