/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.PrebillingDataException;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.model.StatoCalcoloHandler;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.tariffe.StatoCalcoloPod;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ConsumiException
extends PrebillingDataException
implements StatoCalcoloHandler {
    private static final long serialVersionUID = 1L;
    private static final List<PrebillingError> NONBLOCKING = Arrays.asList(ErroriElaborazione.NO_RILEVAZIONI);
    private final Date inizioPeriodo;
    private final Date finePeriodo;
    private final Date dataRilevazione;
    private final Date dataPrevRilevazione;
    private final String matricolaPrev;
    private final String matricola;
    private final String codicePod;

    public ConsumiException(ErroriElaborazione errore) {
        this(errore, null, null, null);
    }

    public ConsumiException(ErroriElaborazione errore, Date inizioPeriodo, Date finePeriodo, String codicePod) {
        this(errore, inizioPeriodo, finePeriodo, null, null, codicePod);
    }

    public ConsumiException(ErroriElaborazione errore, Date inizioPeriodo, Date finePeriodo, Date dataPrevRilevazione, Date dataRilevazione, String codicePod) {
        this(errore, null, null, inizioPeriodo, finePeriodo, dataPrevRilevazione, dataRilevazione, codicePod);
    }

    public ConsumiException(ErroriElaborazione errore, String matricolaPrev, String matricola, Date dataPrevRilevazione, Date dataRilevazione, String codicePod) {
        this(errore, matricolaPrev, matricola, null, null, dataRilevazione, dataPrevRilevazione, codicePod);
    }

    public ConsumiException(ErroriElaborazione errore, String matricolaPrev, String matricola, Date inizioPeriodo, Date finePeriodo, Date dataPrevRilevazione, Date dataRilevazione, String codicePod) {
        super(errore);
        this.matricolaPrev = matricolaPrev;
        this.matricola = matricola;
        this.inizioPeriodo = inizioPeriodo;
        this.finePeriodo = finePeriodo;
        this.dataPrevRilevazione = dataPrevRilevazione;
        this.dataRilevazione = dataRilevazione;
        this.codicePod = codicePod;
    }

    public Date getInizioPeriodo() {
        return this.inizioPeriodo;
    }

    public Date getFinePeriodo() {
        return this.finePeriodo;
    }

    public Date getDataRilevazione() {
        return this.dataRilevazione;
    }

    public Date getDataPrevRilevazione() {
        return this.dataPrevRilevazione;
    }

    public String getMatricolaPrev() {
        return this.matricolaPrev;
    }

    public String getMatricola() {
        return this.matricola;
    }

    public String getCodicePod() {
        return this.codicePod;
    }

    public List<String> getParams() {
        DateFormat dateFormat = StrategyHelper.getDataFormat();
        return Arrays.asList(ConsumiException.format(dateFormat, this.inizioPeriodo), ConsumiException.format(dateFormat, this.finePeriodo), ConsumiException.format(dateFormat, this.dataPrevRilevazione), ConsumiException.format(dateFormat, this.dataRilevazione), this.matricolaPrev, this.matricola, this.codicePod);
    }

    private static String format(DateFormat format, Date date) {
        return date == null ? "" : format.format(date);
    }

    @Override
    public StatoCalcoloPod getStatoCalcolo() {
        PrebillingError errore = this.getErrore();
        return NONBLOCKING.contains(errore) ? StatoCalcoloPod.OK : StatoCalcoloPod.BLOCKED;
    }
}

