/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.IncoherentEndDates;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.MisuraFasceQuantita;
import biz.elabor.prebilling.model.tariffe.TariffaApplicazione;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.tariffe.ContrattoWrapper;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.Tariffa;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TariffeMesePod;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.DataException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.text.Format;
import org.homelinux.elabor.tools.MathUtils;

public abstract class AbstractExportTariffeStrategy
implements ServiceStrategy {
    private static final String TESTATA = "@4;PREZZI INDICIZZATI;1";
    private static final DateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("dd/MM/yy");
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private static final DecimalFormat DUE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "00");
    private static final DecimalFormat QUATTRO_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "0000");
    private static final DecimalFormat SETTE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "000.00+;000.00-");
    private static final DecimalFormat DODICI_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "000000000.0+;000000000.0-");
    private static final DecimalFormat TARIFFE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "000000.00000000+;000000.00000000-");
    private static final DecimalFormat COEFF_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "#0.00");
    private static final DecimalFormat CONSUMO_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "###,##0.000");
    private static final DecimalFormat PREZZO_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "###,##0.00000000");
    private static final DecimalFormat IMPORTO_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "###,##0.00000000");
    private static final String SOMMA_IMPORTI_ORARI_LABEL = "SOMMA IMPORTI ORARI";
    private static final String SOMMA_CONSUMI_LABEL = "SOMMA CONSUMI";
    private static final String PREZZO_MEDIO_PONDERATO_LABEL = "PREZZO MEDIO PONDERATO";
    private static final String PREZZO_MEDIO_POND_PERD_LABEL = "PREZZO MEDIO PONDERATO CON PERDITE";
    private static final String COEFF_PERDITE_LABEL = "ALIQUOTA PERDITE";
    protected final int anno;
    protected final Month mese;
    private final Date dataMax;
    private final Destinatari destinatari;
    protected final TalkManager talkManager;
    private final int nCifre;
    private final TipoCalcolo tipo;
    protected final PrebillingConfiguration configuration;

    protected abstract void exportTariffe(ListMap<String, TariffaMultiApplicazione> var1, String var2, ServiceStatus var3) throws IOException;

    protected abstract ListMap<String, TariffaMultiApplicazione> getTariffe(ServiceStatus var1);

    protected abstract File getFolder(String var1, String var2);

    public AbstractExportTariffeStrategy(int anno, Month mese, Date dataMax, Destinatari destinatari, TipoCalcolo tipo, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.dataMax = dataMax;
        this.destinatari = destinatari;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.nCifre = this.configuration.getCifreTariffe();
        this.tipo = tipo;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            ListMap<String, TariffaMultiApplicazione> tariffe = this.getTariffe(status);
            String meseStr = String.valueOf(this.anno) + DUE_FORMAT.format(this.mese.getIndex());
            int commitCount = status.getCommitCount();
            DateFormat timestampFormat = StrategyCommonHelper.getTimestampFormat();
            String fileSpec = String.valueOf(timestampFormat.format(new Date())) + (commitCount == 0 ? "" : "-" + commitCount);
            String fileName = "tariffe-" + meseStr + "-" + fileSpec + ".csv";
            this.exportTariffe(tariffe, fileName, status);
            ok = true;
        }
        catch (IOException exc) {
            Warning sentence = new Warning("export.tariffe", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    protected void fillTariffe(List<TariffaMultiApplicazione> listaTariffeMese, Map<String, TariffeMesePod> mappaTariffeMese) {
        for (TariffaMultiApplicazione tariffaMese : listaTariffeMese) {
            Warning sentence;
            Contratto contratto = tariffaMese.getContratto();
            String codicePod = contratto.getCodice();
            TariffeMesePod tariffeMesePod = AbstractExportTariffeStrategy.getTariffeMesePod(codicePod, mappaTariffeMese);
            try {
                ContrattoWrapper wrapper = this.destinatari.getWrapper(contratto);
                double aqconsum = contratto.getAqconsum();
                Date dataScadenza = contratto.getDataScadenza();
                if (dataScadenza == null) {
                    dataScadenza = this.dataMax;
                } else if (this.dataMax != null) {
                    dataScadenza = CalendarTools.min(this.dataMax, dataScadenza);
                }
                boolean rettifica = tariffaMese.isRettifica();
                Tariffa tariffa = new Tariffa(contratto, wrapper, tariffaMese, aqconsum, dataScadenza, rettifica);
                tariffeMesePod.add(tariffa);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                sentence = new Warning("get.contratti", message);
                String key = exc.getKey();
                sentence.addParam(key);
                sentence.addParam(codicePod);
                this.talkManager.addSentence(sentence);
            }
            catch (DataException exc) {
                String message = exc.getMessage();
                sentence = new Warning("get.contratti", "invalid.value");
                sentence.addParam(message);
                sentence.addParam(codicePod);
                this.talkManager.addSentence(sentence);
            }
        }
    }

    private static TariffeMesePod getTariffeMesePod(String codicePod, Map<String, TariffeMesePod> mappaTariffeMese) {
        TariffeMesePod tariffeMesePod = mappaTariffeMese.get(codicePod);
        if (tariffeMesePod == null) {
            tariffeMesePod = new TariffeMesePod();
            mappaTariffeMese.put(codicePod, tariffeMesePod);
        }
        return tariffeMesePod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printTariffe(File outFile, String azienda, Map<String, TariffeMesePod> mappaTariffeAzienda, ServiceStatus status) throws IOException {
        boolean outFileExists = outFile.exists();
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            FileWriter fw = new FileWriter(outFile, true);
            try {
                block21: {
                    BufferedWriter bw = new BufferedWriter(fw);
                    try {
                        try (PrintWriter writer = new PrintWriter(bw);){
                            if (!outFileExists) {
                                writer.println(TESTATA);
                            }
                            for (TariffeMesePod tariffePod : mappaTariffeAzienda.values()) {
                                for (List list : tariffePod.values()) {
                                    this.printTariffe(list, writer);
                                    status.count(azienda, "opzioni tariffarie", list.size());
                                }
                            }
                        }
                        if (bw == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (bw == null) throw throwable;
                        ((Writer)bw).close();
                        throw throwable;
                    }
                    ((Writer)bw).close();
                }
                if (fw == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (fw == null) throw throwable;
                ((Writer)fw).close();
                throw throwable;
            }
            ((Writer)fw).close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private void printTariffe(List<Tariffa> tariffe, PrintWriter writer) {
        for (Tariffa tariffa : tariffe) {
            this.printTariffa(tariffa, writer);
            TariffaMultiApplicazione penale = tariffa.getTariffa().getPenale();
            if (penale == null) continue;
            Contratto contratto = tariffa.getContratto();
            ContrattoWrapper wrapper = tariffa.getWrapper();
            Tariffa tariffaPenale = new Tariffa(contratto, wrapper, penale, 0.0, null, false);
            this.printTariffa(tariffaPenale, writer);
        }
    }

    private void printTariffa(Tariffa tariffa, PrintWriter writer) {
        TariffaMultiApplicazione tariffaMulti = tariffa.getTariffa();
        Date startDate = tariffa.getStartDate();
        Date dataScadenza = tariffa.getDataScadenza();
        Date dataSospensione = tariffa.getDataSospensione();
        Date fineTariffa = CalendarTools.minNullable(dataScadenza, dataSospensione);
        Date dataRevoca = tariffa.getDataRevoca();
        String codIndiceEnergetico = tariffa.getCodIndiceEnergetico();
        String codIndiceApplicato = tariffa.getCodIndiceApplicato();
        writer.print(";;;");
        writer.print(String.valueOf(SHORT_DATE_FORMAT.format(startDate)) + ";");
        writer.print(String.valueOf(QUATTRO_FORMAT.format(tariffaMulti.getTipoApplicazione())) + ";");
        writer.print(String.valueOf(ExportHelper.fixedLengthNum(codIndiceApplicato, 4)) + ";");
        writer.print("0;");
        writer.print(String.valueOf(this.formatTariffa(tariffaMulti, FasciaOraria.F1)) + ";");
        writer.print(String.valueOf(this.formatTariffa(tariffaMulti, FasciaOraria.F2)) + ";");
        writer.print(String.valueOf(this.formatTariffa(tariffaMulti, FasciaOraria.F3)) + ";");
        writer.print(String.valueOf(fineTariffa == null ? "" : SHORT_DATE_FORMAT.format(fineTariffa)) + ";");
        writer.print(String.valueOf(dataRevoca == null ? "" : SHORT_DATE_FORMAT.format(dataRevoca)) + ";");
        String codicePod = tariffa.getCodicePod();
        writer.print(String.valueOf(ExportHelper.fixedLength(codicePod, 30)) + ";");
        double aqconsum = tariffa.getAqconsum();
        writer.print(String.valueOf(SETTE_FORMAT.format(aqconsum)) + ";");
        double qtmisura = tariffaMulti.getQtMisura();
        writer.print(String.valueOf(DODICI_FORMAT.format(qtmisura)) + ";");
        writer.print(String.valueOf(ExportHelper.fixedLengthNum(codIndiceEnergetico, 4)) + ";");
        writer.println(".");
    }

    public String idFormat(Integer value, DecimalFormat format) {
        return value == null ? "" : format.format(value);
    }

    private String formatTariffa(TariffaMultiApplicazione tariffa, FasciaOraria fascia) {
        double value = tariffa.getPrezzoMedioPonderato(fascia);
        double rounded = MathUtils.round(value, this.nCifre);
        return TARIFFE_FORMAT.format(rounded);
    }

    protected void printTariffe(String azienda, Map<String, TariffeMesePod> mappaTariffeAzienda, String fileName, ServiceStatus status) throws IOException {
        if (!mappaTariffeAzienda.isEmpty()) {
            String idEsecuzione = status.getIdEsecuzione();
            File folder = this.getFolder(idEsecuzione, azienda);
            File outFile = new File(folder, fileName);
            this.printTariffe(outFile, azienda, mappaTariffeAzienda, status);
        }
    }

    protected void printDettagliTariffe(Map<String, TariffeMesePod> tariffeMese, File parent, boolean reseller) throws FileNotFoundException {
        if (!tariffeMese.isEmpty()) {
            File folder = new File(parent, "tariffe");
            for (Map.Entry<String, TariffeMesePod> entryMese : tariffeMese.entrySet()) {
                String codicePod = entryMese.getKey();
                TariffeMesePod tariffeMesePod = entryMese.getValue();
                ListMap<Date, Tariffa> tariffePod = tariffeMesePod.values();
                Character suffix = tariffePod.size() > 1 ? Character.valueOf('A') : null;
                for (Map.Entry entryPod : tariffePod.entrySet()) {
                    Date dataTariffa = (Date)entryPod.getKey();
                    List tariffePodData = (List)entryPod.getValue();
                    String annomese = StrategyCommonHelper.getAnnoMeseDateFormat().format(dataTariffa);
                    Tariffa tariffa = (Tariffa)tariffePodData.get(0);
                    String azienda = tariffa.getAzienda();
                    File subfolder = reseller ? folder : new File(folder, "reseller-" + azienda);
                    subfolder = new File(subfolder, annomese);
                    subfolder.mkdirs();
                    String timestamp = StrategyCommonHelper.getTimestampFormat().format(new Date());
                    String rettifica = tariffa.isRettifica() ? "-R" : "";
                    String fileName = String.valueOf(codicePod) + (suffix == null ? "" : suffix) + "-" + annomese + rettifica + "-" + timestamp + ".csv";
                    File file = new File(subfolder, fileName);
                    this.printDettaglioTariffa(file, codicePod, dataTariffa, tariffePodData);
                    if (suffix == null) continue;
                    suffix = Character.valueOf((char)(suffix.charValue() + '\u0001'));
                }
            }
        }
    }

    private void printDettaglioTariffa(File file, String codicePod, Date dataTariffa, List<Tariffa> tariffePodData) throws FileNotFoundException {
        TariffaMultiApplicazione firstTariffa = tariffePodData.get(0).getTariffa();
        List<DettaglioTariffa> firstDettagli = firstTariffa.getFirstDettagli();
        int hoursNumber = firstDettagli.size();
        if (AbstractExportTariffeStrategy.hasDettagli(tariffePodData)) {
            Throwable throwable = null;
            Object var9_10 = null;
            try (PrintWriter writer = new PrintWriter(file);){
                String meseanno = StrategyHelper.getMeseAnnoFormat().format(dataTariffa);
                writer.println("POD;" + codicePod);
                writer.println("MESE COMPETENZA;" + meseanno);
                this.tipo.printSommaConsumi(firstTariffa, SOMMA_CONSUMI_LABEL, CONSUMO_FORMAT, writer);
                double coeffPerdite = firstTariffa.getCoeffPerdite();
                if (this.configuration.hasPerdite()) {
                    writer.println("ALIQUOTA PERDITE;" + COEFF_FORMAT.format(coeffPerdite));
                    this.tipo.printPrezzoMedioPonderatoPerdite(firstTariffa, PREZZO_MEDIO_POND_PERD_LABEL, IMPORTO_FORMAT, writer);
                }
                for (Tariffa tariffa : tariffePodData) {
                    TariffaMultiApplicazione tariffaMulti = tariffa.getTariffa();
                    TariffaMultiApplicazione penale = tariffaMulti.getPenale();
                    if (penale == null) {
                        if (tariffaMulti.isScivolo()) continue;
                        this.printTestataTariffa(writer, tariffaMulti);
                        continue;
                    }
                    this.printTestataPenale(writer, penale);
                }
                writer.println();
                this.printIntestazione(tariffePodData, writer);
                int index = 0;
                while (index < hoursNumber) {
                    DettaglioTariffa firstDettaglio = firstDettagli.get(index);
                    writer.print(String.valueOf(codicePod) + ";");
                    writer.print(String.valueOf(DEFAULT_DATE_FORMAT.format(firstDettaglio.getData())) + ";");
                    writer.print(String.valueOf(DUE_FORMAT.format(firstDettaglio.getOra())) + ";");
                    writer.print(String.valueOf(IMPORTO_FORMAT.format(firstDettaglio.getAttiva())) + ";");
                    writer.print(String.valueOf(IMPORTO_FORMAT.format(firstDettaglio.getKAttiva())) + ";");
                    writer.print(String.valueOf(IMPORTO_FORMAT.format(firstDettaglio.getPrezzoReale())) + ";");
                    this.tipo.printFascia(firstDettaglio, writer);
                    for (Tariffa tariffa : tariffePodData) {
                        TariffaMultiApplicazione tariffaMulti = tariffa.getTariffa();
                        TariffaMultiApplicazione penale = tariffaMulti.getPenale();
                        if (penale == null) {
                            if (tariffaMulti.isScivolo()) continue;
                            AbstractExportTariffeStrategy.printRigaDettaglio(writer, tariffaMulti, index);
                            continue;
                        }
                        AbstractExportTariffeStrategy.printRigaDettaglio(writer, penale, index);
                    }
                    writer.println();
                    ++index;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static boolean hasDettagli(List<Tariffa> tariffePodData) {
        boolean dettagli = false;
        for (Tariffa tariffaPodData : tariffePodData) {
            TariffaMultiApplicazione tariffaMulti = tariffaPodData.getTariffa();
            if (tariffaMulti.isScivolo() && tariffaMulti.getPenale() == null) continue;
            dettagli = !tariffaMulti.getFirstDettagli().isEmpty();
            break;
        }
        return dettagli;
    }

    private static void printRigaDettaglio(PrintWriter writer, TariffaMultiApplicazione tariffaPodData, int index) {
        for (TariffaApplicazione subTariffa : tariffaPodData.getSubTariffe()) {
            List<DettaglioTariffa> dettagli = subTariffa.getDettagli();
            if (dettagli.isEmpty()) continue;
            DettaglioTariffa dettaglio = dettagli.get(index);
            double attiva = dettaglio.getAttivaEffettiva();
            writer.print(String.valueOf(CONSUMO_FORMAT.format(attiva)) + ";");
            double prezzo = tariffaPodData.isScivolo() && attiva == 0.0 ? 0.0 : dettaglio.getPrezzo();
            writer.print(String.valueOf(PREZZO_FORMAT.format(prezzo)) + ";");
            writer.print(String.valueOf(IMPORTO_FORMAT.format(dettaglio.getCostoOra())) + ";");
        }
    }

    private void printTestataTariffa(PrintWriter writer, TariffaMultiApplicazione tariffa) {
        writer.println();
        int tipoApplicazione = tariffa.getTipoApplicazione();
        List<TariffaApplicazione> subTariffe = tariffa.getSubTariffe();
        this.tipo.printSommaImportiOrari(tariffa, "SOMMA IMPORTI ORARI " + tipoApplicazione, IMPORTO_FORMAT, writer);
        if (subTariffe.size() == 1) {
            this.tipo.printSommaConsumiEffettivi(tariffa, "SOMMA CONSUMI " + tipoApplicazione, CONSUMO_FORMAT, writer);
        } else {
            this.tipo.printSommaConsumiCompl(tariffa, "SOMMA CONSUMI " + tipoApplicazione, CONSUMO_FORMAT, writer);
        }
        this.tipo.printPrezzoMedioPonderatoNetto(tariffa, "PREZZO MEDIO PONDERATO " + tipoApplicazione, IMPORTO_FORMAT, writer);
        if (subTariffe.size() > 1) {
            for (TariffaApplicazione subTariffa : subTariffe) {
                int subTipo = subTariffa.getTipoApplicazione();
                writer.println();
                this.tipo.printSommaImportiOrari(subTariffa, "SOMMA IMPORTI ORARI " + subTipo, IMPORTO_FORMAT, writer);
                this.tipo.printSommaConsumi(subTariffa, "SOMMA CONSUMI " + subTipo, CONSUMO_FORMAT, writer);
                this.tipo.printPrezzoMedioPonderatoNetto(subTariffa, "PREZZO MEDIO PONDERATO " + subTipo, IMPORTO_FORMAT, writer);
            }
        }
    }

    protected void printTestataPenale(PrintWriter writer, TariffaMultiApplicazione tariffa) {
        int tipoApplicazione = tariffa.getTipoApplicazione();
        writer.println();
        this.tipo.printSommaImportiOrari(tariffa, "SOMMA IMPORTI ORARI " + tipoApplicazione, IMPORTO_FORMAT, writer);
        this.tipo.printSommaConsumiEffettivi(tariffa, "SOMMA CONSUMI " + tipoApplicazione, CONSUMO_FORMAT, writer);
        this.tipo.printPrezzoMedioPonderatoNetto(tariffa, "PREZZO MEDIO PONDERATO " + tipoApplicazione, IMPORTO_FORMAT, writer);
    }

    private void printIntestazione(List<Tariffa> tariffePodData, PrintWriter writer) {
        writer.print("POD;");
        writer.print("GIORNO;");
        writer.print("ORA;");
        writer.print("CONSUMO;");
        writer.print("K;");
        writer.print("PUN;");
        if (this.tipo == TipoCalcolo.FASCE) {
            writer.print("FASCIA;");
        }
        for (Tariffa tariffa : tariffePodData) {
            TariffaMultiApplicazione tariffaPodData = tariffa.getTariffa();
            TariffaMultiApplicazione penale = tariffaPodData.getPenale();
            if (penale == null) {
                AbstractExportTariffeStrategy.printIntestazione(writer, tariffaPodData);
                continue;
            }
            AbstractExportTariffeStrategy.printIntestazione(writer, penale);
        }
        writer.println();
    }

    private static void printIntestazione(PrintWriter writer, TariffaMultiApplicazione tariffaPodData) {
        for (TariffaApplicazione subTariffa : tariffaPodData.getSubTariffe()) {
            AbstractExportTariffeStrategy.printIntestazione(writer, subTariffa);
        }
    }

    private static void printIntestazione(PrintWriter writer, TariffaApplicazione subTariffa) {
        int tipoApplicazione = subTariffa.getTipoApplicazione();
        writer.print("CONSUMO " + tipoApplicazione + ";");
        writer.print("PUN " + tipoApplicazione + ";");
        writer.print("IMPORTO ORARIO " + tipoApplicazione + ";");
    }

    protected void checkDettagli(Map<String, TariffeMesePod> mappaTariffe, ServiceStatus status) {
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (Map.Entry<String, TariffeMesePod> entry : mappaTariffe.entrySet()) {
            TariffeMesePod tariffe = entry.getValue();
            try {
                AbstractExportTariffeStrategy.checkDettagli(tariffe);
            }
            catch (IncoherentEndDates exc) {
                String codicePod = exc.getCodice();
                String azienda = exc.getAzienda();
                ErroriElaborazione errore = ErroriElaborazione.INCOHERENT_ENDDATES;
                Message sentence = new Message("compute.tariffe", errore.getMessage());
                sentence.addParam(codicePod);
                sentence.addParam(String.valueOf(this.anno) + "/" + this.mese.getIndex());
                String userMessage = this.talkManager.getMessage(sentence);
                Set<String> erroriTariffe = status.getErroriTariffe();
                String rowEnd = String.valueOf(azienda) + ";" + this.anno + ";" + this.mese.getIndex() + ";";
                erroriTariffe.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd);
                this.talkManager.addSentence(sentence);
                status.removeTariffeResult(codicePod, userMessage, errore);
                toBeRemoved.add(codicePod);
            }
        }
        for (String codicePod : toBeRemoved) {
            mappaTariffe.remove(codicePod);
        }
    }

    private static void checkDettagli(TariffeMesePod tariffeMesePod) throws IncoherentEndDates {
        for (List list : tariffeMesePod.values()) {
            int checkSize = -1;
            for (Tariffa tariffa : list) {
                TariffaMultiApplicazione tariffaMulti = tariffa.getTariffa();
                Contratto contratto = tariffaMulti.getContratto();
                List<TariffaApplicazione> subTariffe = tariffaMulti.getSubTariffe();
                checkSize = AbstractExportTariffeStrategy.checkDettagli(contratto, subTariffe, checkSize);
            }
        }
    }

    private static int checkDettagli(Contratto contratto, List<TariffaApplicazione> subTariffe, int checkSize) throws IncoherentEndDates {
        int size = checkSize;
        for (TariffaApplicazione subTariffa : subTariffe) {
            MisuraFasceQuantita tariffa = subTariffa.getTariffa();
            List<DettaglioTariffa> dettagli = tariffa.getDettagli();
            int currSize = dettagli.size();
            if (currSize <= 0) continue;
            size = currSize;
            if (checkSize < 0 || size == checkSize) continue;
            String azienda = contratto.getReseller();
            String codicePod = contratto.getCodice();
            Date data = contratto.getDataValidita();
            throw new IncoherentEndDates(azienda, codicePod, data);
        }
        return size;
    }
}

