/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.DatiMisura;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.indici.MappaIndici;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.tariffe.CalcolaMedieStrategy;
import biz.elabor.prebilling.services.tariffe.CodiceExtractor;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.structures.setmap.SetMap;

public abstract class AbstractExportRettificheTariffeStrategy
implements ServiceStrategy {
    private static final KeyExtractor<String, DatiMisura> CODICE_EXTRACTOR = new CodiceExtractor();
    private final Destinatari destinatari;
    protected final int annoRif;
    protected final Month meseRif;
    private final TalkManager talkManager;
    private final TipoCalcolo tipo;
    protected final String onlyPod;
    protected final String codiceReseller;
    private final PrebillingConfiguration configuration;
    protected final GiadaDao giadaDao;
    private final IndiciDao indiciDao;
    protected final MisureDao misureDao;
    private final boolean scivoloEnabled;
    private final boolean scivoloForced;
    private final TipoTrattamento onlyTipoTrattamento;
    private final boolean bloccoIndice;

    public AbstractExportRettificheTariffeStrategy(Destinatari destinatari, int anno, Month mese, TipoCalcolo tipo, String onlyPod, String codiceReseller, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice, PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, IndiciDao indiciDao, TalkManager talkManager) {
        this.annoRif = anno;
        this.meseRif = mese;
        this.destinatari = destinatari;
        this.configuration = configuration;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.indiciDao = indiciDao;
        this.talkManager = talkManager;
        this.tipo = tipo;
        this.onlyPod = onlyPod;
        this.codiceReseller = codiceReseller;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.onlyTipoTrattamento = onlyTipoTrattamento;
        this.bloccoIndice = bloccoIndice;
    }

    protected void ensureMeseRif(SetMap<Date, DatiMisura> mesiRettifiche) {
        ElaborCalendar calendar = new ElaborCalendar(this.annoRif, this.meseRif);
        Date dataRif = calendar.getDate();
        Set meseCorrente = (Set)mesiRettifiche.get(dataRif);
        if (meseCorrente == null || meseCorrente.isEmpty()) {
            DatiMisura dataRettificaDummy = new DatiMisura(dataRif, "dummy");
            mesiRettifiche.add(dataRif, dataRettificaDummy);
        }
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok = true;
        try {
            SetMap<Date, DatiMisura> mesiRettifiche = this.getMesiRettifiche(status);
            Date startMonth = (Date)mesiRettifiche.keySet().iterator().next();
            ElaborCalendar calendarStart = new ElaborCalendar(startMonth);
            int annoStart = calendarStart.getAnno();
            Month meseStart = calendarStart.getMese();
            for (Map.Entry entry : mesiRettifiche.entrySet()) {
                Logger logger = status.getLogger();
                Date date = (Date)entry.getKey();
                Set podList = (Set)entry.getValue();
                if (podList.isEmpty()) continue;
                logger.info("================== " + date + ": " + podList.size() + " pod");
                ElaborCalendar calendar = new ElaborCalendar(date);
                int anno = calendar.getAnno();
                Month mese = calendar.getMese();
                status.setMappaIndici(new MappaIndici(anno, mese, this.indiciDao, this.configuration, status));
                LinkedHashSet<String> podSet = new LinkedHashSet<String>();
                StructuresHelper.buildCollection(podSet, podList, CODICE_EXTRACTOR);
                CalcolaMedieStrategy calcolamedieStrategy = new CalcolaMedieStrategy(this.destinatari, anno, mese, this.tipo, podSet, this.onlyPod, this.codiceReseller, this.misureDao, this.giadaDao, this.configuration, this.talkManager, annoStart, meseStart, this.annoRif, this.meseRif, this.scivoloEnabled, this.scivoloForced, this.onlyTipoTrattamento, this.bloccoIndice);
                ok &= calcolamedieStrategy.execute(status);
                boolean requestedMonth = this.annoRif == anno && this.meseRif == mese;
                Date dataMax = requestedMonth ? null : CalendarTools.getEndDate(anno, mese);
                ServiceStrategy exportStrategy = this.destinatari.getExportTariffeStrategy(anno, mese, dataMax, this.tipo, this.configuration, this.talkManager);
                ok &= exportStrategy.execute(status);
            }
        }
        catch (InconsistentOptionException exc) {
            status.resetTariffeBatch();
        }
        return ok;
    }

    protected abstract SetMap<Date, DatiMisura> getMesiRettifiche(ServiceStatus var1);
}

