/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.MisuraD65;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.FlussoStatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.NullReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.switched.AbstractSwitchStatoPodHandler;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public abstract class SwitchStatoPodHandler
extends AbstractSwitchStatoPodHandler<MisuraD65> {
    private static final String SNM = "SNM";
    private static final String SNM2G = "SNM2G";
    private static final String[] FLUSSI = new String[]{"SNM", "SNM2G"};
    public static final List<String> CHECK_FLUSSI = Arrays.asList("SNF", "SOF", "F2G");
    public static final List<String> CHECK_FLUSSI_RETTIFICA = Arrays.asList("SNM");
    private final List<String> checkFlussi;

    public SwitchStatoPodHandler(MisureDao misureDao, List<String> checkFlussi, String prestazione) {
        super(misureDao, prestazione);
        this.checkFlussi = checkFlussi;
    }

    @Override
    public void handleStato(MisuraD65 current, String codicePrestazione, String cpGestore, StatusTransaction transaction) throws DataNotFoundException, StatoPodObsoletoException, StatoPodInvalidoException, PraticaAnnullataException {
        String flusso = this.getCodiceFlusso(current);
        Date dataMisura = current.getDataMisura();
        FlussoStatoPodChecker checker = new FlussoStatoPodChecker(this.checkFlussi);
        NullReferenceHandler referenceHandler = new NullReferenceHandler();
        this.handleStato(current, codicePrestazione, flusso, cpGestore, dataMisura, dataMisura, null, transaction, checker, referenceHandler);
    }

    public void handleStato(MisuraD65 current, String codicePrestazione, String cpGestore, Date dataMovimento, StatusTransaction transaction) throws DataNotFoundException, StatoPodObsoletoException, StatoPodInvalidoException, PraticaAnnullataException {
        String flusso = this.getCodiceFlusso(current);
        FlussoStatoPodChecker checker = new FlussoStatoPodChecker(this.checkFlussi);
        NullReferenceHandler referenceHandler = new NullReferenceHandler();
        this.handleStato(current, codicePrestazione, flusso, cpGestore, dataMovimento, dataMovimento, null, transaction, checker, referenceHandler);
    }

    @Override
    public void addSospeso(StatusTransaction transaction, MisuraD65 smn, ErroriElaborazione errore, String descrizione) {
        MnoResult result = new MnoResult(smn, errore, descrizione);
        transaction.addSnmSospeso(result);
    }

    @Override
    public void check(SafeListMap<String, Prestazione> prestazioni) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        this.check(prestazioni, FLUSSI);
    }
}

