/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.common.MatricoleHelper;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.db.DataNotFoundException;

public class GetSnmStrategy
implements ServiceStrategy {
    private final MisureDao misureDao;
    private final Iterable<StatoMisure> stati;
    private final String filtroPod;
    private final GiadaDao giadaDao;

    public GetSnmStrategy(String filtroPod, MisureDao misureDao, GiadaDao giadaDao, Iterable<StatoMisure> stati) {
        this.filtroPod = filtroPod;
        this.misureDao = misureDao;
        this.giadaDao = giadaDao;
        this.stati = stati;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        List<Mno> snms = this.misureDao.getSnm(this.filtroPod, this.stati);
        this.fixMatricole(snms);
        status.addSnm(snms);
        return true;
    }

    private void fixMatricole(List<Mno> snms) {
        for (Mno snm : snms) {
            this.fixMatricole(snm);
        }
    }

    private void fixMatricole(Mno snm) {
        String flussoFunzionale;
        String matrSnf;
        String codicePod = snm.getCodicePod();
        Date dataMisura = snm.getDataMisura();
        try {
            Date dataInizio = CalendarTools.nextDay(dataMisura);
            Snf snf = this.misureDao.getSnf(codicePod, dataInizio, false);
            matrSnf = snf.getMatrAtt();
            flussoFunzionale = snf.getCodiceFlusso();
        }
        catch (DataNotFoundException exc) {
            matrSnf = "";
            flussoFunzionale = "";
        }
        String matricolaAtt = snm.getMatricolaAtt();
        String string = matricolaAtt = matricolaAtt == null ? "" : matricolaAtt.trim();
        if (matricolaAtt.length() < 16) {
            ElaborCalendar calendar = new ElaborCalendar(dataMisura);
            calendar.addGiorni(1);
            Date date = calendar.getDate();
            matricolaAtt = MatricoleHelper.buildMatricola(codicePod, date, matrSnf, this.giadaDao);
            if (matricolaAtt.length() < 6) {
                matricolaAtt = "SNM_" + snm.getFirstId();
            }
            snm.setMatricole(matricolaAtt);
            snm.setFlussoFunzionale(flussoFunzionale);
        }
    }
}

