/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ListMapKeyDate;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.D65CrmService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;

public class ExportSofCrmStrategy
implements ServiceStrategy {
    private PrebillingConfiguration configuration;
    private TalkManager talkManager;
    private Funzionalita funzionalita;
    private final DecimalFormat usEnergyFormat;
    private final DateFormat timestampFormat;
    private final DateFormat longDateFormat;
    private final DateFormat dateFormat;

    public ExportSofCrmStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.usEnergyFormat = StrategyHelper.getUsEnergyFormat();
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
        this.longDateFormat = StrategyHelper.getFullDateFormat();
        this.dateFormat = StrategyHelper.getDataFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        String idEsecuzione = status.getIdEsecuzione();
        File folder = ConfigurationHelper.getMiddlewareTmpFolder(this.configuration, idEsecuzione, this.funzionalita);
        ListMapKeyDate<Sof> sofs = status.getSofsCrm();
        boolean ok = true;
        for (List list : sofs) {
            for (Sof sof : list) {
                ok &= this.exportSof(folder, sof, status);
            }
        }
        return ok;
    }

    private boolean exportSof(File folder, Sof sof, ServiceStatus status) {
        boolean ok;
        String codicePod = sof.getCodicePod();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
        String dateStr = this.timestampFormat.format(new Date());
        String fileName = "sof-pod-" + codicePod + "-" + dateStr + ".xml";
        File file = new File(folder, fileName);
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            writer.println("<FlussoMisure xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D65\">");
            writer.println("<CodProcesso>SE1</CodProcesso>");
            writer.println("<IdentificativiFlusso>");
            writer.println("<CodContrDisp>" + sof.getCodContrDisp() + "</CodContrDisp>");
            writer.println("</IdentificativiFlusso>");
            Date dataRiferimento = sof.getDate();
            StrategyHelper.printDatiPod(sof, null, dataRiferimento, D65CrmService.BANNED_D65, true, this.usEnergyFormat, this.configuration, writer, this.longDateFormat, this.dateFormat);
            writer.print("</FlussoMisure>");
            writer.close();
            SofResult result = new SofResult(sof, ErroriElaborazione.OK, "");
            status.addSofElaborato(result);
            String flusso = sof.getCodiceFlusso();
            status.count("middleware", flusso, 1);
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.sof.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }
}

