/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.misure.ExtendedMnos;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisuraNonorariaPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.switched.SnmStatoPodHandler;
import biz.elabor.prebilling.services.switched.SwitchStatoPodHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.KeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ExportSnmStrategy
implements ServiceStrategy {
    private final TalkManager talkManager;
    private final PrebillingConfiguration configuration;
    private final Funzionalita funzionalita;
    private final SwitchStatoPodHandler statoPodHandler;
    private final DateFormat timestampFormat;

    public ExportSnmStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.talkManager = talkManager;
        this.configuration = configuration;
        this.statoPodHandler = new SnmStatoPodHandler(misureDao, SwitchStatoPodHandler.CHECK_FLUSSI, "SE1");
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
            this.statoPodHandler.check(prestazioni);
            Set<String> tarDisDom = this.configuration.getTarDisDom();
            ListMapKey<String, Mno> snms = status.getSnms();
            PodMap pods = status.getPodMap();
            HashMap<String, List<ExtendedMnos>> mapMno = new HashMap<String, List<ExtendedMnos>>();
            this.createMap(snms, pods, mapMno, status);
            ok = true;
            for (Map.Entry entry : mapMno.entrySet()) {
                String azienda = (String)entry.getKey();
                List value = (List)entry.getValue();
                List<MisuraNonorariaPod> toExport = this.findToExport(value, status);
                String context = this.getClass().getSimpleName();
                ok &= ExportSnmStrategy.execute(context, this.funzionalita, azienda, toExport, status, tarDisDom, this.timestampFormat, this.configuration, this.talkManager);
            }
        }
        catch (SegnaleNotHandledException exc) {
            Warning sentence = new Warning("export.snm.strategy", "segnale.nothandled");
            sentence.setCss("alert-danger");
            Prestazione prestazione = exc.getPrestazione();
            sentence.addParam(prestazione.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (PrestazioneNotFoundException exc) {
            Warning sentence = new Warning("export.snm.strategy", "prestazione.notfound");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    public static boolean execute(String context, Funzionalita funzionalita, String azienda, List<MisuraNonorariaPod> misure, ServiceStatus status, Set<String> tarDisDom, DateFormat timestampFormat, PrebillingConfiguration configuration, TalkManager talkManager) {
        boolean ok;
        PrebillingContext.setContext(context, "azienda: " + azienda);
        String idEsecuzione = status.getIdEsecuzione();
        File folder = ConfigurationHelper.getResellerTmpImportFolder(configuration, idEsecuzione, azienda, funzionalita);
        String timestamp = timestampFormat.format(new Date());
        String fileName = "switch-snm-misure-" + azienda + "-" + timestamp + ".txt";
        File file = new File(folder, fileName);
        try {
            if (!misure.isEmpty()) {
                PrintWriter writer = new PrintWriter(file);
                int lunghezzaMatricola = configuration.getLunghezzaMatricola();
                GestFile16Helper.printGestFile16Header(writer, "", lunghezzaMatricola);
                for (MisuraNonorariaPod misura : misure) {
                    Pod pod = misura.getPod();
                    String codicePod = pod.getCodice();
                    PrebillingContext.setContext("ExportSnmStrategy.execute", "pod: " + codicePod);
                    try {
                        StatusTransaction transaction = new StatusTransaction(azienda, status, configuration);
                        transaction.setAzienda(azienda);
                        ExportSnmStrategy.execute(transaction, tarDisDom, writer, misura, configuration);
                        transaction.commit(codicePod);
                    }
                    catch (RuntimeException exc) {
                        String description = StrategyHelper.handleRuntimeException(exc, codicePod, "export.snm.strategy", talkManager, status);
                        MisuraNonoraria snm = misura.getMisura();
                        MnoResult result = new MnoResult(snm, ErroriElaborazione.EXCLUDING_ERROR, description);
                        status.addSnmSospeso(result);
                    }
                }
                writer.close();
            }
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.snm.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private static void execute(StatusTransaction transaction, Set<String> tarDisDom, PrintWriter writer, MisuraNonorariaPod mnoPod, PrebillingConfiguration configuration) {
        Pod pod = mnoPod.getPod();
        MisuraNonoraria mno = mnoPod.getMisura();
        boolean checkReattiva = StrategyHelper.checkReattiva(pod, tarDisDom);
        Misura misura = mno.getMisura();
        int nFasce = misura.getFasce();
        String codiceFlusso = mno.getCodiceFlusso();
        Set<String> id = mno.getId();
        Misura misAnte = GestFile16Helper.buildMisuraZero(nFasce, codiceFlusso, id);
        GestFile16Helper.writeMisura(writer, pod, misAnte, mno, "G", configuration, checkReattiva);
        transaction.addSnmElaborato(new MnoResult(mno, ErroriElaborazione.OK, ""));
        String label = mno.getCountLabel();
        transaction.count(label);
    }

    /*
     * Unable to fully structure code
     */
    private List<MisuraNonorariaPod> findToExport(List<ExtendedMnos> snmList, ServiceStatus status) {
        resellers = status.getResellers();
        toExport = new ArrayList<MisuraNonorariaPod>();
        block2: for (ExtendedMnos eSnm : snmList) {
            pod = eSnm.getPod();
            azienda = pod.getAzienda();
            try {
                transaction = new StatusTransaction(azienda, status, this.configuration);
                this.findToExport(transaction, resellers, toExport, eSnm);
                codicePod = pod.getCodice();
                transaction.commit(codicePod);
                continue;
            }
            catch (RuntimeException exc) {
                codicePod = pod.getCodice();
                descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.snm.strategy", this.talkManager, status);
                ** for (snm : eSnm.getMnos())
            }
lbl-1000:
            // 1 sources

            {
                result = new MnoResult(snm, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                status.addSnmSospeso(result);
                continue;
lbl19:
                // 1 sources

            }
        }
        return toExport;
    }

    /*
     * Unable to fully structure code
     */
    private void findToExport(StatusTransaction transaction, SafeMap<String, Reseller> resellers, List<MisuraNonorariaPod> toExport, ExtendedMnos eSnm) {
        block7: {
            listSnms = eSnm.getMnos();
            pod = eSnm.getPod();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + pod.getCodice());
            azienda = pod.getAzienda();
            try {
                reseller = (Reseller)resellers.get(azienda);
                handleStato = reseller.isHandleStato();
                for (Mno snm : listSnms) {
                    snm.setCdaziend(azienda);
                    misuraNonorariaPod = new MisuraNonorariaPod(null, pod, snm);
                    if (handleStato) {
                        this.statoPodHandler.handleStato(snm, transaction);
                    }
                    toExport.add(misuraNonorariaPod);
                }
                break block7;
            }
            catch (DataNotFoundException exc) {
                this.handleException(transaction, listSnms, exc);
                break block7;
            }
            catch (StatoPodCheckException exc) {
                this.handleException(transaction, listSnms, exc);
                break block7;
            }
            catch (PraticaAnnullataException exc) {
                message = exc.getMessage();
                key = exc.getKey();
                sentence = new Message("export.snm.strategy", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                descrizione = this.talkManager.getMessage(sentence);
                ** for (snm : listSnms)
            }
lbl-1000:
            // 1 sources

            {
                result = new MnoResult(snm, ErroriElaborazione.RESELLER_NOT_FOUND, descrizione);
                transaction.addSnmObsoleto(result);
                continue;
            }
        }
    }

    private void handleException(StatusTransaction transaction, List<Mno> listSnms, KeyException exc) {
        String message = exc.getMessage();
        String key = exc.getKey();
        Message sentence = new Message("export.snm.strategy", message);
        sentence.setCss("alert-danger");
        sentence.addParam(key);
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        for (Mno snm : listSnms) {
            this.statoPodHandler.addSospeso(transaction, snm, ErroriElaborazione.RESELLER_NOT_FOUND, descrizione);
        }
    }

    private void createMap(ListMapKey<String, Mno> snms, PodMap pods, Map<String, List<ExtendedMnos>> mapMno, ServiceStatus status) {
        for (Map.Entry entry : snms.entrySet()) {
            String codicePod = (String)entry.getKey();
            PrebillingContext.setContext("ExportSnmStrategy.createMap", "pod: " + codicePod);
            List mnoList = (List)entry.getValue();
            this.createMap(pods, mapMno, mnoList, codicePod, status);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createMap(PodMap pods, Map<String, List<ExtendedMnos>> mapMno, List<Mno> mnoList, String codicePod, ServiceStatus status) {
        block3: {
            try {
                pod = pods.get(codicePod);
                ExportSnmStrategy.handleKX(pod, mnoList);
                ExportSnmStrategy.checkAtteso(pod);
                ExportSnmStrategy.insertMno(mapMno, mnoList, pod);
                break block3;
            }
            catch (DataNotFoundException exc) {
                message = exc.getMessage();
                key = exc.getKey();
                sentence = new Warning("export.snm.strategy", message);
                sentence.addParam(key);
                errore = StrategyHelper.getErroreElaborazione(exc);
                this.talkManager.addSentence(sentence);
                descrizione = this.talkManager.getMessage(sentence);
                ** for (mno : mnoList)
            }
lbl-1000:
            // 1 sources

            {
                result = new MnoResult(mno, errore, descrizione);
                status.addSnmSospeso(result);
                continue;
            }
        }
    }

    private static void checkAtteso(Pod pod) throws DataNotFoundException {
        if (!pod.isAttesaSnm()) {
            if (pod.isOrario()) {
                if (!pod.isNuovaFornitura()) {
                    String codicePod = pod.getCodice();
                    int errore = ErroriElaborazione.SNM_FORNITURA_ORARIA.ordinal();
                    throw new DataNotFoundException("snm.nuovafornitura", codicePod, errore);
                }
            } else {
                String codicePod = pod.getCodice();
                int errore = ErroriElaborazione.SNM_NON_ATTESO.ordinal();
                throw new DataNotFoundException("snm.nonatteso", codicePod, errore);
            }
        }
    }

    private static void handleKX(Pod pod, List<Mno> mnoList) throws DataNotFoundException {
        for (Mno mno : mnoList) {
            StrategyHelper.handleKX(pod, mno);
        }
    }

    private static void insertMno(Map<String, List<ExtendedMnos>> mapMno, List<Mno> mnoList, Pod pod) {
        String azienda = pod.getAzienda();
        List<ExtendedMnos> eMnos = mapMno.get(azienda);
        if (eMnos == null) {
            eMnos = new ArrayList<ExtendedMnos>();
            mapMno.put(azienda, eMnos);
        }
        ExtendedMnos eMno = new ExtendedMnos(pod, mnoList);
        eMnos.add(eMno);
    }
}

