/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.common.AbstractD65CsvService;
import biz.elabor.prebilling.services.common.AbstractExportNoCrmService;
import biz.elabor.prebilling.services.switched.D65SnfCsvService;
import biz.elabor.prebilling.services.switched.SnfD65;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportSnfNoCrmStrategy
extends AbstractExportNoCrmService
implements ServiceStrategy {
    private final Funzionalita funzionalita;
    private final AbstractD65CsvService d65Service;

    public ExportSnfNoCrmStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(configuration);
        this.funzionalita = funzionalita;
        this.d65Service = new D65SnfCsvService("SE1", configuration, talkManager);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        String idEsecuzione = status.getIdEsecuzione();
        Map<String, List<SnfD65>> snfNoCrm = status.getSnfsNoCrm();
        boolean ok = true;
        for (Map.Entry<String, List<SnfD65>> entry : snfNoCrm.entrySet()) {
            String azienda = entry.getKey();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "azienda: " + azienda);
            List<SnfD65> snfs = entry.getValue();
            String timestamp = this.timestampFormat.format(new Date());
            String fileName = "switch-d65-dati-funzionali-nonorari-" + azienda + "-" + timestamp + ".csv";
            File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
            File file = new File(folder, fileName);
            ok = this.d65Service.export(azienda, snfs, file, status);
            if (!ok) break;
        }
        return ok;
    }
}

