/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ListMapKeyDate;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.StatusManager;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.common.D65CrmService;
import biz.elabor.prebilling.services.switched.SnfD65;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportSnfCrmStrategy
implements ServiceStrategy {
    private TalkManager talkManager;
    private final D65CrmService d65CrmService;

    public ExportSnfCrmStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.talkManager = talkManager;
        this.d65CrmService = new D65CrmService(funzionalita, configuration, talkManager);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMapKeyDate<SnfD65> snfCrm = status.getSnfsCrm();
        boolean ok = true;
        for (Map.Entry entry : snfCrm.entrySet()) {
            String codicePod = (String)entry.getKey();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
            List snfs = (List)entry.getValue();
            List<SnfD65> toExport = this.findToExport(snfs, status);
            ok &= this.d65CrmService.export(toExport, "snf-pod", codicePod, "SE1", true, (StatusManager)status);
        }
        return ok;
    }

    private List<SnfD65> findToExport(List<SnfD65> snfs, ServiceStatus status) {
        ArrayList<SnfD65> toExport = new ArrayList<SnfD65>();
        for (SnfD65 snf : snfs) {
            try {
                ExportSnfCrmStrategy.checkCottimi(snf, status);
                toExport.add(snf);
            }
            catch (InvalidValueException e2) {
                String message = e2.getMessage();
                Message sentence = new Message("export.snf.strategy", message);
                sentence.addParam(snf.getCodicePod());
                sentence.setCss("alert-danger");
                this.talkManager.addSentence(sentence);
            }
        }
        return toExport;
    }

    private static void checkCottimi(SnfD65 snf, ServiceStatus status) throws InvalidValueException {
        Map<String, String> mappaDettagli = snf.getDatiPod().get("DatiPdp");
        String gruppoMis = mappaDettagli.get("GruppoMis");
        if (gruppoMis != null && gruppoMis.equals("NO")) {
            status.addSnfEscluso(new SnfResult(snf, ErroriElaborazione.NO_GRUPPO_MISURA, "gruppo misura mancante"));
            throw new InvalidValueException("gruppomisura");
        }
        String forfait = mappaDettagli.get("Forfait");
        if (forfait != null && forfait.equals("SI")) {
            status.addSnfEscluso(new SnfResult(snf, ErroriElaborazione.FORFAIT, "misura a forfait"));
            throw new InvalidValueException("forfait");
        }
    }
}

