/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.D65;
import biz.elabor.prebilling.model.misure.DateContainer;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.AbstractPrestazioneStatoPodHandler;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import java.util.Arrays;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public abstract class AbstractSwitchStatoPodHandler<S extends D65 & DateContainer>
extends AbstractPrestazioneStatoPodHandler<S> {
    private final String codicePrestazione;

    protected abstract void check(SafeListMap<String, Prestazione> var1) throws SegnaleNotHandledException, PrestazioneNotFoundException;

    protected abstract void addSospeso(StatusTransaction var1, S var2, ErroriElaborazione var3, String var4);

    public AbstractSwitchStatoPodHandler(MisureDao misureDao) {
        this(misureDao, "SE1");
    }

    public AbstractSwitchStatoPodHandler(MisureDao misureDao, String codicePrestazione) {
        super("E", misureDao);
        this.codicePrestazione = codicePrestazione;
    }

    public void check(SafeListMap<String, Prestazione> prestazioni, String[] flussi) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        this.check(prestazioni, StrategyHelper.SWITCH_CDUNIPRE_LIST, Arrays.asList(flussi));
    }

    public void handleStato(S current, StatusTransaction transaction) throws DataNotFoundException, StatoPodCheckException, PraticaAnnullataException {
        String cpGestore = current.getCodPratAtt();
        this.handleStato(current, this.codicePrestazione, cpGestore, transaction);
    }
}

