/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ListMapKeyDate;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.DateContainer;
import biz.elabor.prebilling.model.misure.DefaultDatiFlusso;
import biz.elabor.prebilling.model.misure.DefaultDatiFunzionali;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.switched.AbstractFunctionalStatoPodHandler;
import biz.elabor.prebilling.services.switched.CrmSwitchHandler;
import biz.elabor.prebilling.services.switched.NoCrmSwitchHandler;
import biz.elabor.prebilling.services.switched.SwitchesHandler;
import biz.elabor.prebilling.services.switched.TrattamentoSwitchHandler;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public abstract class AbstractSelectSwitchStrategy<S extends DefaultDatiFunzionali & DateContainer>
implements ServiceStrategy {
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private final String flusso;
    private final AbstractFunctionalStatoPodHandler<S> statoPodHandler;
    private final TrattamentoSwitchHandler<S> trattamentoSwitchHandler;

    public abstract ListMapKeyDate<S> getSfs(ServiceStatus var1);

    public abstract void addSospesi(ServiceStatus var1, List<S> var2, ErroriElaborazione var3, String var4);

    public abstract void handleCommerciale(S var1, PraticaVolo var2, StatusTransaction var3) throws DataNotFoundException;

    public AbstractSelectSwitchStrategy(String flusso, PrebillingConfiguration configuration, TalkManager talkManager, AbstractFunctionalStatoPodHandler<S> statoPodHandler, TrattamentoSwitchHandler<S> trattamentoHandler) {
        this.statoPodHandler = statoPodHandler;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.flusso = flusso;
        this.trattamentoSwitchHandler = trattamentoHandler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
            this.statoPodHandler.check(prestazioni);
            ListMapKeyDate<S> switches = this.getSfs(status);
            for (List list : switches) {
                DefaultDatiFunzionali switchRecord = (DefaultDatiFunzionali)list.get(0);
                String azienda = switchRecord.getCdaziend();
                String codicePod = switchRecord.getCodicePod();
                try {
                    StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
                    this.handle(list, transaction);
                    transaction.commit(codicePod);
                }
                catch (RuntimeException exc) {
                    String description = StrategyHelper.handleRuntimeException(exc, codicePod, "select.switch.strategy", this.talkManager, status);
                    this.addSospesi(status, list, ErroriElaborazione.EXCLUDING_ERROR, description);
                }
            }
            ok = true;
        }
        catch (SegnaleNotHandledException exc) {
            Warning sentence = new Warning("select.switch.strategy", "segnale.nothandled");
            sentence.setCss("alert-danger");
            Prestazione prestazione = exc.getPrestazione();
            sentence.addParam(prestazione.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (PrestazioneNotFoundException exc) {
            Warning sentence = new Warning("select.switch.strategy", "prestazione.notfound");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void handle(List<S> switchList, StatusTransaction transaction) {
        DefaultDatiFunzionali sf = (DefaultDatiFunzionali)switchList.get(0);
        String codicePod = sf.getKey();
        try {
            String destinazione;
            Date dataInizio = sf.getDataInizio();
            PraticaVolo pratica = StrategyHelper.getPiv(codicePod, dataInizio, transaction);
            this.handleCommerciale(sf, pratica, transaction);
            String azienda = pratica.getCodiceReseller();
            SafeMap<String, Reseller> resellers = transaction.getResellers();
            Reseller reseller = (Reseller)resellers.get(azienda);
            this.setAzienda(switchList, azienda);
            boolean handleStato = reseller.isHandleStato();
            if (this.configuration.hasCrm()) {
                boolean resellerCrm = reseller.isCrm();
                DispatchingFlussi dispatchingFlussi = transaction.getDispatchingFlussi();
                String prestazione = pratica.getCodicePrestazione();
                destinazione = dispatchingFlussi.getDestinazione("E", prestazione, this.flusso, azienda, resellerCrm);
            } else {
                destinazione = "";
            }
            if (destinazione == null) {
                this.handleListCrm(switchList, azienda, transaction, handleStato);
            } else {
                this.handleListNoCrm(switchList, azienda, transaction, handleStato);
            }
        }
        catch (StatoPodCheckException | DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            this.handleSospesi(switchList, transaction, errore, message, key);
        }
        catch (PraticaAnnullataException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            this.handleObsoleti(switchList, transaction, errore, message, key);
        }
    }

    private void setAzienda(List<S> switchList, String azienda) {
        for (DefaultDatiFunzionali current : switchList) {
            current.setCdaziend(azienda);
        }
    }

    private void handleSospesi(List<S> switchList, StatusTransaction transaction, ErroriElaborazione codiceErrore, String message, String key) {
        Message sentence = new Message("select.switch.strategy", message);
        sentence.addParam(key);
        sentence.setCss("alert-danger");
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        for (DefaultDatiFunzionali item : switchList) {
            this.statoPodHandler.addSospeso(transaction, item, codiceErrore, descrizione);
        }
    }

    private void handleObsoleti(List<S> switchList, StatusTransaction transaction, ErroriElaborazione codiceErrore, String message, String key) {
        Message sentence = new Message("select.switch.strategy", message);
        sentence.addParam(key);
        sentence.setCss("alert-danger");
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        for (DefaultDatiFunzionali item : switchList) {
            this.statoPodHandler.addObsoleto(transaction, item, codiceErrore, descrizione);
        }
    }

    private void handleList(SwitchesHandler<S> handler, List<S> switchList, String azienda, StatusTransaction transaction, boolean handleStato) throws DataNotFoundException, StatoPodCheckException, PraticaAnnullataException {
        for (DefaultDatiFunzionali item : switchList) {
            this.handle(handler, item, azienda, transaction, handleStato);
        }
    }

    private void handle(SwitchesHandler<S> handler, S current, String azienda, StatusTransaction transaction, boolean handleStato) throws DataNotFoundException, StatoPodCheckException, PraticaAnnullataException {
        if (handleStato) {
            this.statoPodHandler.handleStato(current, transaction);
        }
        ((DefaultDatiFlusso)current).setCdaziend(azienda);
        handler.add(current, transaction);
    }

    private void handleListNoCrm(List<S> switchList, String azienda, StatusTransaction transaction, boolean handleStato) throws DataNotFoundException, StatoPodCheckException, PraticaAnnullataException {
        NoCrmSwitchHandler<S> handler = new NoCrmSwitchHandler<S>(this.trattamentoSwitchHandler);
        this.handleList(handler, switchList, azienda, transaction, handleStato);
    }

    private void handleListCrm(List<S> switchList, String azienda, StatusTransaction transaction, boolean handleStato) throws DataNotFoundException, StatoPodCheckException, PraticaAnnullataException {
        CrmSwitchHandler<S> handler = new CrmSwitchHandler<S>(this.trattamentoSwitchHandler);
        this.handleList(handler, switchList, azienda, transaction, handleStato);
    }
}

