/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.riallineamento;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.riallineamento.RiallMno;
import biz.elabor.prebilling.util.DefaultMapWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ExportRiallineamentoStrategy
implements ServiceStrategy {
    private final int anno;
    private final Month mese;
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private final Funzionalita funzionalita;
    private final DateFormat timestampFormat;

    public ExportRiallineamentoStrategy(Funzionalita funzionalita, int anno, Month mese, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    private static Map<String, List<Pod>> buildPodsMap(DefaultPodMap pods) {
        LinkedHashMap<String, List<Pod>> podsMap = new LinkedHashMap<String, List<Pod>>();
        for (Pod pod : pods) {
            String reseller = pod.getAzienda();
            ArrayList<Pod> resellerPods = (ArrayList<Pod>)podsMap.get(reseller);
            if (resellerPods == null) {
                resellerPods = new ArrayList<Pod>();
                podsMap.put(reseller, resellerPods);
            }
            resellerPods.add(pod);
        }
        return podsMap;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        String idEsecuzione = status.getIdEsecuzione();
        DefaultPodMap pods = status.getAllPods();
        SafeMap<String, Mno> pnos = status.getRiallineamentoPnos();
        Map<String, List<Pod>> podsMap = ExportRiallineamentoStrategy.buildPodsMap(pods);
        boolean ok = true;
        for (Map.Entry<String, List<Pod>> entry : podsMap.entrySet()) {
            String reseller = entry.getKey();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "azienda: " + reseller);
            List<Pod> resellerPods = entry.getValue();
            ok &= this.exportReseller(idEsecuzione, reseller, resellerPods, pnos);
        }
        return ok;
    }

    private boolean exportReseller(String idEsecuzione, String reseller, List<Pod> resellerPods, SafeMap<String, Mno> pnos) {
        boolean ok;
        Set<String> tarDisDom = this.configuration.getTarDisDom();
        File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, reseller, this.funzionalita);
        String timestamp = this.timestampFormat.format(new Date());
        String identificatore = String.valueOf(reseller) + "-" + this.anno + "-" + this.mese.getIndex() + "-" + timestamp + ".txt";
        String fileName = "riallineamento-" + identificatore;
        File file = new File(folder, fileName);
        File scartati = new File(folder, "scartati-" + fileName);
        try {
            PrintWriter scartatiWriter = new PrintWriter(scartati);
            PrintWriter exportWriter = new PrintWriter(file);
            int lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
            GestFile16Helper.printGestFile16Header(exportWriter, "", lunghezzaMatricola);
            for (Pod pod : resellerPods) {
                String codicePod = pod.getCodice();
                Class<?> strategyClass = this.getClass();
                String strategyName = strategyClass.getSimpleName();
                PrebillingContext.setContext(strategyName, "pod: " + codicePod);
                try {
                    PrintWriter writer;
                    Mno pno = (Mno)pnos.get(codicePod);
                    Date dataMisura = pno.getDataMisura();
                    PrintWriter printWriter = writer = !pod.isAllineato() && !pod.isAzzeramento(dataMisura) ? exportWriter : scartatiWriter;
                    if (StrategyHelper.checkAllineamentoStretto(pod, pno, true, tarDisDom)) {
                        writer = scartatiWriter;
                    }
                    String matricolaAtt = pno.getMatricolaAtt();
                    String matricolaRea = pno.getMatricolaRea();
                    String matricolaPot = pno.getMatricolaPot();
                    String[] matrAnte = new String[]{matricolaAtt, matricolaRea, matricolaPot};
                    Misura misAnte = pno.getMisura();
                    boolean checkReattiva = StrategyHelper.checkReattiva(pod, tarDisDom);
                    RiallMno mno = new RiallMno(pno, !checkReattiva);
                    DefaultMapWriter mapWriter = new DefaultMapWriter();
                    GestFile16Helper.write(pod, false, matrAnte, misAnte, mno, "5", "5", mapWriter, this.configuration);
                    mapWriter.flush(writer);
                }
                catch (DataNotFoundException exc) {
                    Warning sentence = new Warning("export.riallineamento.strategy", "pno.notfound");
                    sentence.setCss("alert-danger");
                    sentence.addParam(codicePod);
                    this.talkManager.addSentence(sentence);
                }
            }
            exportWriter.close();
            scartatiWriter.close();
            ok = true;
        }
        catch (FileNotFoundException e2) {
            Warning sentence = new Warning("export.riallineamento.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }
}

