/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.rettifiche;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.SmartPodMap;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.letture.ErrorePdo;
import biz.elabor.prebilling.services.letture.IncoherenceException;
import biz.elabor.prebilling.services.letture.MisuraNonZeroException;
import biz.elabor.prebilling.services.letture.MisureOrarieService;
import biz.elabor.prebilling.services.rettifiche.DateCondition;
import biz.elabor.prebilling.services.rettifiche.RfoEnvironment;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.BasicKeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;

public class ExportRfoStrategy
implements ServiceStrategy {
    public static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private final int anno;
    private final Month mese;
    private final Reseller queryReseller;
    private final TipoEstrazione tipo;
    private final String onlyPod;
    private final PrebillingConfiguration configuration;
    private final GiadaDao giadaDao;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final MisureOrarieService misureOrarieService;

    public ExportRfoStrategy(int anno, Month mese, Reseller queryReseller, TipoEstrazione tipo, String onlyPod, PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.queryReseller = queryReseller;
        this.tipo = tipo;
        this.onlyPod = onlyPod;
        this.configuration = configuration;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.misureOrarieService = new MisureOrarieService(null, configuration, null);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            this.export(status);
            ok = true;
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("export.rfo.strategy", message);
            sentence.addParam(exc.getKey());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (CalendarNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("export.rfo.strategy", message);
            sentence.addParam(exc.getKey());
            sentence.addParam(exc.getCodicePod());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void export(ServiceStatus status) throws DataNotFoundException, CalendarNotFoundException {
        Map<Date, Map<String, Pdo>> rfos = status.getRfoMap();
        for (Map.Entry<Date, Map<String, Pdo>> entry : rfos.entrySet()) {
            Date dataRiferimento = entry.getKey();
            ElaborCalendar calendar = new ElaborCalendar(dataRiferimento);
            int annoRiferimento = calendar.getAnno();
            Month meseRiferimento = calendar.getMese();
            SmartPodMap pods = new SmartPodMap(annoRiferimento, meseRiferimento, this.onlyPod, this.configuration, this.giadaDao);
            Map<String, Pdo> rfoMap = entry.getValue();
            for (Pdo rfo : rfoMap.values()) {
                this.export(rfo, pods, status);
            }
        }
    }

    private void export(Pdo rfo, PodMap pods, ServiceStatus status) throws DataNotFoundException, CalendarNotFoundException {
        String codicePod = rfo.getCodicePod();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
        Pod pod = this.filtriOk(rfo, pods);
        if (pod != null) {
            String azienda = pod.getAzienda();
            rfo.setCdaziend(azienda);
            String codiceFlusso = rfo.getFirstCodiceFlusso();
            String regime = rfo.getRegime();
            RilMese rilMese = rfo.getRilMese();
            if (codiceFlusso.endsWith("2G") && regime != null && regime.contentEquals("R") && (this.anno != rilMese.getAnno() || this.mese != rilMese.getMese())) {
                status.addLogRfo(rfo);
            } else {
                this.export(rfo, pod, status);
            }
        }
    }

    private void export(Pdo rfo, Pod pod, ServiceStatus status) throws DataNotFoundException, CalendarNotFoundException {
        String codicePod = rfo.getCodicePod();
        try {
            String descrizione;
            ErrorePdo errorePdo;
            String azienda = rfo.getCdaziend();
            StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
            Set<ErrorePdo> errori = this.writeRettifica(rfo, pod, transaction);
            String flusso = rfo.getFirstCodiceFlusso();
            Set<String> id = rfo.getId();
            if (errori.isEmpty()) {
                errorePdo = new ErrorePdo(ErroriElaborazione.OK, flusso, id);
                descrizione = "";
            } else {
                errorePdo = errori.iterator().next();
                String message = errorePdo.getErrore().getMessage();
                Warning sentence = new Warning("aggregation.strategy", message);
                sentence.addParam(codicePod);
                sentence.setCss("alert-warning");
                descrizione = this.talkManager.getMessage(sentence);
            }
            transaction.commit(codicePod);
            ErroriElaborazione errore = errorePdo.getErrore();
            PdoResult result = new PdoResult(rfo, errore, descrizione, id);
            status.addRfoElaborato(azienda, result);
            status.count(azienda, flusso, 1);
        }
        catch (RuntimeException exc) {
            String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.rettifiche.strategy", this.talkManager, status);
            PdoResult result = new PdoResult(rfo, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
            status.addRfoSospeso(result);
        }
        catch (IncoherenceException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("export.rettifiche.strategy", message);
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            status.addRfoSospeso(new PdoResult(rfo, errore, descrizione));
        }
        catch (StatoPodCheckException exc) {
            this.handleException(exc, rfo, status);
        }
        catch (PraticaAnnullataException exc) {
            this.handleException(exc, rfo, status);
        }
        catch (MisuraNonZeroException exc) {
            Message sentence = new Message("export.rfo.strategy", "misura.nonzero");
            sentence.setCss("alert-danger");
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            PdoResult result = new PdoResult(rfo, ErroriElaborazione.MISURA_NON_ZERO, descrizione);
            status.addPdoSospeso(result);
        }
    }

    private void handleException(BasicKeyException exc, Pdo rfo, ServiceStatus status) {
        String message = exc.getMessage();
        Message sentence = new Message("export.rettifiche.strategy", message);
        sentence.setCss("alert-danger");
        sentence.addParam(exc.getKey());
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
        status.addRfoSospeso(new PdoResult(rfo, errore, descrizione));
    }

    private Pod filtriOk(Pdo current, PodMap pods) {
        Pod pod;
        String codicePod = current.getCodicePod();
        try {
            boolean filtroTipo;
            pod = pods.getOnly(codicePod);
            String azienda = pod.getAzienda();
            current.setCdaziend(azienda);
            RilMese rilMese = current.getRilMese();
            int annoRfo = rilMese.getAnno();
            Month meseRfo = rilMese.getMese();
            Date dataCompetenza = CalendarTools.getDate(annoRfo, meseRfo, 1);
            Date endDate = CalendarTools.getEndDate(this.anno, this.mese);
            boolean filtroData = dataCompetenza.before(endDate);
            boolean filtroReseller = this.queryReseller.match(azienda);
            boolean bl = filtroTipo = !this.tipo.equals((Object)TipoEstrazione.NONORARI) && pod.isOrario();
            if (!(filtroData && filtroReseller && filtroTipo)) {
                pod = null;
            }
        }
        catch (DataNotFoundException e2) {
            String message = e2.getMessage();
            String key = e2.getKey();
            Warning sentence = new Warning("export.rettifiche.strategy", message);
            sentence.setCss("alert-warning");
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
            pod = null;
        }
        return pod;
    }

    private Set<ErrorePdo> writeRettifica(Pdo rfo, Pod pod, StatusTransaction transaction) throws DataNotFoundException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException {
        List<SpecificaTecnica> dateSpecs = pod.getSpecificheTecniche();
        dateSpecs = ExportRfoStrategy.removeUltimoGiornoMese(rfo, dateSpecs);
        Reseller reseller = new Reseller(null, null, null, false, false);
        String codicePod = rfo.getCodicePod();
        RilMese rilMese = rfo.getRilMese();
        int annoRil = rilMese.getAnno();
        Month meseRil = rilMese.getMese();
        ElaborCalendar calendar = new ElaborCalendar(annoRil, meseRil);
        calendar.addMesi(1);
        Date last = calendar.getDate();
        String codiceFlusso = rfo.getFirstCodiceFlusso();
        Pdo pdo = codiceFlusso.endsWith("2G") ? this.misureDao.getPdoConsolidato(codicePod, annoRil, meseRil, last) : rfo;
        RfoEnvironment environment = new RfoEnvironment();
        return this.misureOrarieService.generateMisure(true, reseller, pod, pdo, transaction, dateSpecs, environment);
    }

    private static List<SpecificaTecnica> removeUltimoGiornoMese(Pdo rfo, List<SpecificaTecnica> dateSpecs) {
        RilMese rilMese = rfo.getRilMese();
        int annoRil = rilMese.getAnno();
        Month meseRil = rilMese.getMese();
        Date ultimoGiornoMese = CalendarTools.getEndDate(annoRil, meseRil);
        DateCondition condition = new DateCondition(ultimoGiornoMese);
        Filter<SpecificaTecnica> filter = new Filter<SpecificaTecnica>(condition);
        return filter.filter(dateSpecs);
    }
}

